/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.Widget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlItemDisplay
extends Control
implements ITooltip {
    public boolean hastooltip = false;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private boolean rotating = false;

    public ControlItemDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlItemDisplay(IWidget parent, int f, int y, ItemStack stack, boolean tooltip) {
        this(parent, f, y, 16);
        this.setItemStack(stack);
        if (tooltip) {
            this.setTooltip();
        }
    }

    public ControlItemDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
    }

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (this.itemStack.func_190926_b()) {
            return;
        }
        Point relativeToWindow = this.getAbsolutePosition().sub(this.getTopParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100 || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100) {
            return;
        }
        GlStateManager.func_179126_j();
        if (this.getSize().x() != 16) {
            GlStateManager.func_179094_E();
            float scale = (float)this.getSize().x() / 16.0f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            RenderUtil.drawItem(Point.ZERO, this.itemStack, this.rotating);
            GlStateManager.func_179121_F();
        } else {
            RenderUtil.drawItem(Point.ZERO, this.itemStack, this.rotating);
        }
        GlStateManager.func_179141_d();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip) {
        if (this.hastooltip && !this.itemStack.func_190926_b()) {
            boolean advancedItemTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
            List itemStackTooltip = this.itemStack.func_82840_a(((Window)this.getTopParent()).getPlayer(), advancedItemTooltips);
            tooltip.add(itemStackTooltip);
            tooltip.setItemStack(this.itemStack);
        }
        super.getTooltip(tooltip);
    }

    public void setRotating() {
        this.rotating = true;
    }
}

