/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.geometry;

public class Point {
    public static final Point ZERO = new Point(0, 0);
    private final int x;
    private final int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(Point o) {
        this.x = o.x();
        this.y = o.y();
    }

    public static Point add(Point a, Point b) {
        return new Point(a.x() + b.x(), a.y() + b.y());
    }

    public static Point sub(Point a, Point b) {
        return new Point(a.x() - b.x(), a.y() - b.y());
    }

    public Point sub(Point a) {
        return Point.sub(this, a);
    }

    public Point add(Point other) {
        return Point.add(this, other);
    }

    public Point add(int dx, int dy) {
        return Point.add(this, new Point(dx, dy));
    }

    public Point copy() {
        return new Point(this);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public boolean equals(Point other) {
        return this.x() == other.x() && this.y() == other.y();
    }
}

