/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.scroll;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScroll;
import binnie.core.gui.controls.scroll.IControlScrollable;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlScrollBar
extends Control {
    protected final IControlScrollable scrollable;

    public ControlScrollBar(ControlScroll parent) {
        this(parent, 0, 0, parent.getSize().x(), parent.getSize().y(), parent.getScrollableWidget());
    }

    public ControlScrollBar(IWidget parent, int x, int y, int w, int h, IControlScrollable scrollable2) {
        super(parent, x, y, w, h);
        this.scrollable = scrollable2;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler(new EventMouse.Drag.Handler(){

            @Override
            public void onEvent(EventMouse.Drag event) {
                ControlScrollBar.this.scrollable.movePercentage(event.getDy() / (float)(ControlScrollBar.this.height() - ControlScrollBar.this.getBarHeight()));
            }
        });
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                float shownPercentage = ControlScrollBar.this.scrollable.getPercentageShown();
                float percentageIndex = ControlScrollBar.this.scrollable.getPercentageIndex();
                float minPercent = (1.0f - shownPercentage) * percentageIndex;
                float maxPercent = minPercent + shownPercentage;
                float clickedPercentage = (float)ControlScrollBar.this.getRelativeMousePosition().y() / ((float)ControlScrollBar.this.height() - 2.0f);
                if ((clickedPercentage = Math.max(Math.min(clickedPercentage, 1.0f), 0.0f)) > maxPercent) {
                    ControlScrollBar.this.scrollable.setPercentageIndex((clickedPercentage - shownPercentage) / (1.0f - shownPercentage));
                }
                if (clickedPercentage < minPercent) {
                    ControlScrollBar.this.scrollable.setPercentageIndex(clickedPercentage / (1.0f - shownPercentage));
                }
            }
        });
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public boolean isEnabled() {
        return this.scrollable.getPercentageShown() < 0.99f;
    }

    public int getBarHeight() {
        return Math.round((float)this.height() * this.scrollable.getPercentageShown());
    }

    protected Area getRenderArea() {
        int height = this.getBarHeight();
        if (height < 6) {
            height = 6;
        }
        int yOffset = Math.round((float)(this.height() - this.getBarHeight()) * this.scrollable.getPercentageIndex());
        return new Area(0, yOffset, this.getSize().x(), height);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        Area renderArea = this.getRenderArea();
        CraftGUITexture texture = CraftGUITexture.ScrollDisabled;
        if (this.isMouseOver()) {
            texture = CraftGUITexture.ScrollHighlighted;
        } else if (this.isEnabled()) {
            texture = CraftGUITexture.Scroll;
        }
        CraftGUI.render.texture((Object)texture, renderArea);
    }
}

