/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.listbox;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlOption;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventKey;
import binnie.core.util.IValidator;
import java.util.Collection;

public class ControlListBox<T>
extends ControlScrollableContent<ControlList<T>>
implements IControlValue<T> {
    public ControlListBox(IWidget parent, int x, int y, int w, int h, int scrollBarSize) {
        super(parent, x, y, w, h, scrollBarSize);
    }

    @Override
    public void initialise() {
        ControlList content = (ControlList)this.getContent();
        Object defaultValue = content == null ? null : (Object)content.getDefaultValue();
        ControlList<Object> child = new ControlList<Object>(this, 1, 1, this.width() - 2 - this.scrollBarSize, this.height() - 2, defaultValue);
        this.setScrollableContent(child);
        this.addEventHandler(new EventKey.Down.Handler(){

            @Override
            public void onEvent(EventKey.Down event) {
                if (ControlListBox.this.calculateIsMouseOver()) {
                    int currentIndex = ((ControlList)ControlListBox.this.getContent()).getCurrentIndex();
                    if (event.getKey() == 208) {
                        if (++currentIndex >= ((ControlList)ControlListBox.this.getContent()).getOptions().size()) {
                            currentIndex = 0;
                        }
                    } else if (event.getKey() == 200 && --currentIndex < 0) {
                        currentIndex = ((ControlList)ControlListBox.this.getContent()).getOptions().size() - 1;
                    }
                    ((ControlList)ControlListBox.this.getContent()).setIndex(currentIndex);
                }
            }
        });
    }

    @Override
    public final T getValue() {
        return ((ControlList)this.getContent()).getValue();
    }

    @Override
    public final void setValue(T value) {
        ((ControlList)this.getContent()).setValue(value);
    }

    public void setOptions(Collection<T> options) {
        ((ControlList)this.getContent()).setOptions(options);
    }

    public IWidget createOption(T value, int y) {
        return new ControlOption<T>((ControlList)this.getContent(), value, y);
    }

    public void setValidator(IValidator<IWidget> validator) {
        ((ControlList)this.getContent()).setValidator(validator);
    }
}

