/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.listbox.ControlTextOption;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Position;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlTabIcon;
import binnie.core.gui.window.Panel;
import binnie.genetics.gui.ControlGenesisOption;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class WindowGenesis
extends Window {
    private ISpeciesRoot root;
    private IAllele[] template;
    private ControlListBox<Gene> geneList;
    private ControlListBox<Gene> geneOptions;
    private Panel panelPickup;

    public WindowGenesis(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        super(342, 228, player, inventory, side);
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.getInstance();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Genesis";
    }

    @Override
    public void initialiseClient() {
        new ControlPlayerInventory(this);
        this.setTitle("Genesis");
        ControlTabBar<BreedingSystem> tabSystems = new ControlTabBar<BreedingSystem>((IWidget)this, 8, 28, 23, 100, Position.LEFT, Binnie.GENETICS.getActiveSystems()){

            @Override
            public ControlTab<BreedingSystem> createTab(int x, int y, int w, int h, BreedingSystem value) {
                return new ControlTabIcon<BreedingSystem>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public ItemStack getItemStack() {
                        ISpeciesType type = ((BreedingSystem)this.value).getDefaultType();
                        IIndividual ind = ((BreedingSystem)this.value).getDefaultIndividual();
                        return ((BreedingSystem)this.value).getSpeciesRoot().getMemberStack(ind, type);
                    }

                    @Override
                    public String getName() {
                        return ((BreedingSystem)this.value).getName();
                    }

                    @Override
                    public int getOutlineColour() {
                        return ((BreedingSystem)this.value).getColour();
                    }

                    @Override
                    public boolean hasOutline() {
                        return true;
                    }
                };
            }
        };
        this.root = Binnie.GENETICS.getActiveSystems().iterator().next().getSpeciesRoot();
        this.template = this.root.getDefaultTemplate();
        Area one = new Area(32, 28, 170, 100);
        Area two = new Area(214, 28, 100, 100);
        new Panel(this, one.outset(1), MinecraftGUI.PanelType.Black);
        new Panel(this, two.outset(1), MinecraftGUI.PanelType.Black);
        this.geneList = new ControlListBox<Gene>((IWidget)this, one.xPos(), one.yPos(), one.width(), one.height(), 10){

            @Override
            public IWidget createOption(Gene value, int y) {
                return new ControlGenesisOption((ControlList)this.getContent(), value, y);
            }
        };
        this.geneOptions = new ControlListBox<Gene>((IWidget)this, two.xPos(), two.yPos(), two.width(), two.height(), 10){

            @Override
            public IWidget createOption(Gene value, int y) {
                return new ControlTextOption<Gene>((ControlList)this.getContent(), value, y);
            }
        };
        tabSystems.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                WindowGenesis.this.root = ((BreedingSystem)event.getValue()).getSpeciesRoot();
                WindowGenesis.access$102(WindowGenesis.this, WindowGenesis.this.root.getDefaultTemplate());
                WindowGenesis.this.refreshTemplate(null);
            }
        }.setOrigin(EventHandler.Origin.Self, tabSystems));
        this.geneList.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IChromosomeType chromo;
                Map<IChromosomeType, List<IAllele>> map = Binnie.GENETICS.getChromosomeMap(WindowGenesis.this.root);
                ArrayList<Gene> opts = new ArrayList<Gene>();
                IChromosomeType iChromosomeType = chromo = event.value != null ? ((Gene)event.value).getChromosome() : null;
                if (chromo != null) {
                    for (IAllele allele : map.get(chromo)) {
                        opts.add(new Gene(allele, chromo, WindowGenesis.this.root));
                    }
                }
                WindowGenesis.this.geneOptions.setOptions(opts);
            }
        }.setOrigin(EventHandler.Origin.Self, this.geneList));
        this.geneOptions.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IAllele allele;
                if (event.value == null) {
                    return;
                }
                IChromosomeType chromo = ((Gene)event.value).getChromosome();
                ((WindowGenesis)WindowGenesis.this).template[chromo.ordinal()] = allele = ((Gene)event.value).getAllele();
                ISpeciesRoot speciesRoot = ((Gene)event.value).getSpeciesRoot();
                if (chromo == speciesRoot.getSpeciesChromosomeType()) {
                    WindowGenesis.access$102(WindowGenesis.this, speciesRoot.getTemplate(allele.getUID()));
                }
                WindowGenesis.this.refreshTemplate(chromo);
            }
        }.setOrigin(EventHandler.Origin.Self, this.geneOptions));
        this.panelPickup = new Panel(this, 16, 140, 60, 42, MinecraftGUI.PanelType.Black);
        this.refreshTemplate(null);
    }

    private void refreshTemplate(@Nullable IChromosomeType selection) {
        IChromosomeType[] arr$;
        ArrayList<Gene> genes = new ArrayList<Gene>();
        IChromosomeType[] chromos = arr$ = Binnie.GENETICS.getChromosomeMap(this.root).keySet().toArray(new IChromosomeType[0]);
        for (IChromosomeType type : arr$) {
            IAllele allele = this.template[type.ordinal()];
            if (allele == null) {
                throw new NullPointerException("Allele missing for Chromosome " + type.getName());
            }
            genes.add(new Gene(allele, type, this.root));
        }
        Map<IChromosomeType, List<IAllele>> map = Binnie.GENETICS.getChromosomeMap(this.root);
        this.geneList.setOptions(genes);
        if (selection != null) {
            this.geneList.setValue(new Gene(this.template[selection.ordinal()], selection, this.root));
        } else {
            this.geneOptions.setOptions(new ArrayList());
        }
        this.refreshPickup();
    }

    private void refreshPickup() {
        this.panelPickup.deleteAllChildren();
        int i = 0;
        for (ISpeciesType type : Binnie.GENETICS.getSystem(this.root).getActiveTypes()) {
            IIndividual ind = this.root.templateAsIndividual(this.template);
            ind.analyze();
            final ItemStack stack = this.root.getMemberStack(ind, type);
            ControlItemDisplay display = new ControlItemDisplay(this.panelPickup, 4 + i % 3 * 18, 4 + i / 3 * 18);
            display.setItemStack(stack);
            display.setTooltip();
            display.addEventHandler(new EventMouse.Down.Handler(){

                @Override
                public void onEvent(EventMouse.Down event) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    stack.func_77955_b(nbt);
                    ((Window)Window.get(event.getOrigin())).sendClientAction("genesis", nbt);
                }
            }.setOrigin(EventHandler.Origin.Self, display));
            ++i;
        }
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        super.receiveGuiNBTOnServer(player, name, nbt);
        if (name.equals("genesis")) {
            int fit;
            ItemStack stack = new ItemStack(nbt);
            InventoryPlayer playerInv = player.field_71071_by;
            if (stack.func_190926_b()) {
                return;
            }
            if (playerInv.func_70445_o().func_190926_b()) {
                playerInv.func_70437_b(stack);
            } else if (playerInv.func_70445_o().func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)stack) && (fit = stack.func_77976_d() - (stack.func_190916_E() + playerInv.func_70445_o().func_190916_E())) >= 0) {
                ItemStack itemStack;
                ItemStack rec = itemStack = stack;
                itemStack.func_190917_f(playerInv.func_70445_o().func_190916_E());
                playerInv.func_70437_b(rec);
            }
            player.field_71070_bA.func_75142_b();
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71113_k();
            }
        }
    }

    static /* synthetic */ IAllele[] access$102(WindowGenesis x0, IAllele[] x1) {
        x0.template = x1;
        return x1;
    }
}

