package binnie.genetics.genetics;

import javax.annotation.Nullable;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import net.minecraftforge.common.util.Constants;

import binnie.core.genetics.Gene;
import binnie.genetics.api.IGene;

public class SequencerItem extends GeneItem {
	public int sequenced;
	public boolean analysed;

	public SequencerItem(IGene gene) {
		super(gene);
		sequenced = 0;
		analysed = false;
	}

	@Nullable
	public static SequencerItem create(ItemStack itemStack) {
		NBTTagCompound nbt = itemStack.func_77978_p();
		if (nbt != null &&
			nbt.func_150297_b("gene", Constants.NBT.TAG_COMPOUND) &&
			nbt.func_150297_b("seq", Constants.NBT.TAG_BYTE) &&
			nbt.func_74764_b("ana")
			) {
			NBTTagCompound geneNbt = nbt.func_74775_l("gene");
			Gene gene = Gene.create(geneNbt);
			SequencerItem sequencerItem = new SequencerItem(gene);
			sequencerItem.sequenced = nbt.func_74771_c("seq");
			sequencerItem.analysed = nbt.func_74767_n("ana");
			return sequencerItem;
		}
		return null;
	}

	@Override
	public NBTTagCompound writeToNBT(NBTTagCompound nbt2) {
		NBTTagCompound nbt = super.writeToNBT(nbt2);
		nbt.func_74774_a("seq", (byte) sequenced);
		nbt.func_74757_a("ana", analysed);
		return nbt;
	}
}
