package binnie.extratrees.machines.nursery;

import javax.annotation.Nullable;
import java.util.HashSet;
import java.util.Set;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;

import binnie.core.machines.TileEntityMachine;

public class TileEntityNursery extends TileEntityMachine implements IButterflyNursery {
	public TileEntityNursery(final Nursery.PackageNursery pack) {
		super(pack);
	}

	@Nullable
	IButterflyNursery getNursery() {
		return this.getMachine().getInterface(IButterflyNursery.class);
	}

	boolean hasNursery() {
		return this.getNursery() != null;
	}

	@Override
	public World func_145831_w() {
		return this.field_145850_b;
	}

	@Override
	public EnumTemperature getTemperature() {
		return EnumTemperature.NORMAL;
	}

	@Override
	public EnumHumidity getHumidity() {
		return EnumHumidity.NORMAL;
	}

	public boolean addProduct(final ItemStack product, final boolean all) {
		return false;
	}

	@Override
	@Nullable
	public IButterfly getCaterpillar() {
		IButterflyNursery nursery = this.getNursery();
		return nursery != null ? nursery.getCaterpillar() : null;
	}

	@Override
	public void setCaterpillar(@Nullable final IButterfly butterfly) {
		IButterflyNursery nursery = this.getNursery();
		if (nursery != null) {
			nursery.setCaterpillar(butterfly);
		}
	}

	@Override
	@Nullable
	public IIndividual getNanny() {
		return null;
	}

	@Override
	public boolean canNurse(final IButterfly butterfly) {
		return this.getCaterpillar() == null;
	}

	@Override
	public Biome getBiome() {
		return this.func_145831_w().func_180494_b(func_174877_v());
	}

	public void setErrorState(final IErrorState state) {
	}

	@Nullable
	public IErrorState getErrorState() {
		return null;
	}

	public void setErrorState(final int state) {
	}

	public boolean setErrorCondition(final boolean condition, final IErrorState errorState) {
		return false;
	}

	public Set<IErrorState> getErrorStates() {
		return new HashSet<>();
	}

	public int getBiomeId() {
		return 0;
	}

	public int getErrorOrdinal() {
		return 0;
	}

	@Override
	public BlockPos getCoordinates() {
		return func_174877_v();
	}

	@Override
	public World getWorldObj() {
		return field_145850_b;
	}
}
