package binnie.extratrees.machines.lumbermill;

import net.minecraft.item.ItemStack;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.ExtraTreesErrorCode;

public class LumbermillLogic extends ComponentProcessSetCost implements IProcess {
	public static final int PROCESS_ENERGY = 900;
	public static final int PROCESS_LENGTH = 30;
	public static final int WATER_PER_TICK = 10;

	public LumbermillLogic(final Machine machine) {
		super(machine, PROCESS_ENERGY, PROCESS_LENGTH);
	}

	@Override
	public ErrorState canWork() {
		MachineUtil util = getUtil();
		ItemStack logStack = util.getStack(LumbermillMachine.SLOT_LOG);
		if (logStack.func_190926_b()) {
			return new ErrorState(ExtraTreesErrorCode.LUMBERMILL_NO_WOOD, LumbermillMachine.SLOT_LOG);
		}
		final ItemStack plankResult = LumbermillRecipes.getPlankProduct(logStack);
		if (!util.isSlotEmpty(LumbermillMachine.SLOT_PLANKS) && !plankResult.func_190926_b()) {
			final ItemStack currentPlank = util.getStack(LumbermillMachine.SLOT_PLANKS);
			if (!plankResult.func_77969_a(currentPlank) || plankResult.func_190916_E() + currentPlank.func_190916_E() > currentPlank.func_77976_d()) {
				return new ErrorState(ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_PLANKS, new int[]{LumbermillMachine.SLOT_PLANKS});
			}
		}
		if(!util.isSlotEmpty(LumbermillMachine.SLOT_BARK)){
			ItemStack itemStack = util.getStack(LumbermillMachine.SLOT_BARK);
			if (itemStack.func_190916_E() + 1 > itemStack.func_77976_d()) {
				return new ErrorState(ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_BARK, new int[]{LumbermillMachine.SLOT_BARK});
			}
		}
		if(!util.isSlotEmpty(LumbermillMachine.SLOT_SAWDUST)){
			ItemStack itemStack = util.getStack(LumbermillMachine.SLOT_SAWDUST);
			if (itemStack.func_190916_E() + 1 > itemStack.func_77976_d()) {
				return new ErrorState(ExtraTreesErrorCode.LUMBERMILL_NO_SPACE_SAW_DUST, new int[]{LumbermillMachine.SLOT_SAWDUST});
			}
		}
		return super.canWork();
	}

	@Override
	public ErrorState canProgress() {
		if (!this.getUtil().liquidInTank(LumbermillMachine.TANK_WATER, 5)) {
			return new ErrorState(ExtraTreesErrorCode.LUMBERMILL_INSUFFICIENT_WATER, LumbermillMachine.TANK_WATER);
		}
		return super.canProgress();
	}

	@Override
	protected void onFinishTask() {
		MachineUtil util = getUtil();
		final ItemStack logStack = util.getStack(LumbermillMachine.SLOT_LOG);
		final ItemStack result = LumbermillRecipes.getPlankProduct(logStack);
		if (result == null) {
			return;
		}
		util.addStack(LumbermillMachine.SLOT_PLANKS, result);
		util.addStack(LumbermillMachine.SLOT_SAWDUST, ExtraTreeItems.Sawdust.get(1));
		util.addStack(LumbermillMachine.SLOT_BARK, ExtraTreeItems.Bark.get(1));
		util.decreaseStack(LumbermillMachine.SLOT_LOG, 1);
	}

	@Override
	protected void onTickTask() {
		this.getUtil().drainTank(LumbermillMachine.TANK_WATER, WATER_PER_TICK);
	}
}
