package binnie.core.network.packet;

import javax.annotation.Nullable;
import java.io.IOException;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import io.netty.buffer.ByteBuf;

public class MessageTileNBT extends MessageNBT implements IPacketLocation {
	private int posX;
	private int posY;
	private int posZ;

	public MessageTileNBT(final MessageBinnie message) {
		super(message);
	}

	public MessageTileNBT(final int id, final TileEntity tile, final NBTTagCompound nbt) {
		super(id);
		this.posX = tile.func_174877_v().func_177958_n();
		this.posY = tile.func_174877_v().func_177956_o();
		this.posZ = tile.func_174877_v().func_177952_p();
		this.nbt = nbt;
	}

	@Override
	public void writeData(final ByteBuf data) throws IOException {
		data.writeInt(this.posX);
		data.writeInt(this.posY);
		data.writeInt(this.posZ);
		super.writeData(data);
	}

	@Override
	public void readData(final ByteBuf data) throws IOException {
		this.posX = data.readInt();
		this.posY = data.readInt();
		this.posZ = data.readInt();
		super.readData(data);
	}

	@Override
	@Nullable
	public TileEntity getTarget(final World world) {
		return world.func_175625_s(new BlockPos(this.posX, this.posY, this.posZ));
	}

	@Override
	public int getX() {
		return this.posX;
	}

	@Override
	public int getY() {
		return this.posY;
	}

	@Override
	public int getZ() {
		return this.posZ;
	}

	@Override
	public NBTTagCompound getTagCompound() {
		return this.nbt;
	}

	@Override
	void setTagCompound(final NBTTagCompound nbt) {
		this.nbt = nbt;
	}
}
