package binnie.core.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IModelManager;

public class ItemMisc extends ItemCore {
	private IItemMiscProvider[] items;

	public ItemMisc(final CreativeTabs tab, final IItemMiscProvider[] items) {
		super("misc");
		this.func_77637_a(tab);
		this.func_77627_a(true);
		this.func_77655_b("misc");
		this.items = items;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(final Item itemIn, final CreativeTabs creativeTabs, NonNullList<ItemStack> subItems) {
		for (IItemMiscProvider item : this.items) {
			if (item.isActive()) {
				subItems.add(this.getStack(item, 1));
			}
		}
	}

	private IItemMiscProvider getItem(int damage) {
		return (damage >= this.items.length) ? this.items[0] : this.items[damage];
	}

	public ItemStack getStack(IItemMiscProvider type, int size) {
		return new ItemStack(this, size, type.ordinal());
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		super.func_77624_a(stack, playerIn, tooltip, advanced);
		IItemMiscProvider item = this.getItem(stack.func_77952_i());
		item.addInformation(tooltip);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (IItemMiscProvider type : items) {
			manager.registerItemModel(item, type.ordinal(), "misc/" + type.getModelPath());
		}
	}

	@Override
	public String func_77653_i(final ItemStack stack) {
		IItemMiscProvider item = this.getItem(stack.func_77952_i());
		return item.getDisplayName(stack);
	}
}
