package binnie.core.gui.minecraft;

import javax.annotation.Nullable;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.InventorySlot;

public class CustomSlot extends Slot {
	public CustomSlot(final IInventory inventory, final int index) {
		super(inventory, index, 0, 0);
	}

	@Override
	public boolean func_75214_a(final ItemStack stack) {
		return !stack.func_190926_b() && this.field_75224_c.func_94041_b(this.getSlotIndex(), stack);
	}

	@Nullable
	public InventorySlot getInventorySlot() {
		final IInventorySlots slots = Machine.getInterface(IInventorySlots.class, this.field_75224_c);
		if (slots != null) {
			return slots.getSlot(this.getSlotIndex());
		}
		return null;
	}

	public boolean handleClick() {
		final InventorySlot slot = this.getInventorySlot();
		return slot != null && slot.isRecipe();
	}

	public void onSlotClick(final ContainerCraftGUI container, final int dragType, final ClickType modifier, final EntityPlayer player) {
		ItemStack stack = player.field_71071_by.func_70445_o();
		//TODO modifier==mouseButton2?
		if (stack.func_190926_b() || modifier == ClickType.PICKUP_ALL) {
			this.func_75215_d(ItemStack.field_190927_a);
		} else {
			stack = stack.func_77946_l();
			stack.func_190920_e(1);
			this.func_75215_d(stack);
		}
	}
}
