/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.Binnie;
import binnie.botany.api.IFlower;
import binnie.core.AbstractMod;
import binnie.core.genetics.BreedingSystem;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.Widget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScrollBar;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.Position;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlide;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.gui.window.Panel;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.gui.analyst.AnalystPageBehaviour;
import binnie.genetics.gui.analyst.AnalystPageBiology;
import binnie.genetics.gui.analyst.AnalystPageDatabase;
import binnie.genetics.gui.analyst.AnalystPageDescription;
import binnie.genetics.gui.analyst.AnalystPageGenome;
import binnie.genetics.gui.analyst.AnalystPageKaryogram;
import binnie.genetics.gui.analyst.AnalystPageMutations;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.ControlTooltip;
import binnie.genetics.gui.analyst.bee.AnalystPageProducts;
import binnie.genetics.gui.analyst.butterfly.AnalystPageSpecimen;
import binnie.genetics.gui.analyst.flower.AnalystPageAppearance;
import binnie.genetics.gui.analyst.flower.AnalystPageSoil;
import binnie.genetics.gui.analyst.tree.AnalystPageClimate;
import binnie.genetics.gui.analyst.tree.AnalystPageFruit;
import binnie.genetics.gui.analyst.tree.AnalystPageGrowth;
import binnie.genetics.gui.analyst.tree.AnalystPageWood;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.analyser.Analyser;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IButterfly;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowAnalyst
extends Window {
    @Nullable
    IWidget baseWidget = null;
    ControlScrollableContent leftPage;
    ControlScrollableContent rightPage;
    @Nullable
    Control tabBar = null;
    Panel analystPanel;
    List<ControlAnalystPage> analystPages = new ArrayList<ControlAnalystPage>();
    @Nullable
    Area analystPageSize = null;
    boolean isDatabase = false;
    boolean isMaster = false;
    boolean lockedSearch = false;
    @Nullable
    IIndividual current = null;
    @Nullable
    BreedingSystem currentSystem = null;
    private Control analystNone;
    private ControlSlide slideUpInv;

    public WindowAnalyst(EntityPlayer player, @Nullable IInventory inventory, Side side, boolean database, boolean master) {
        super(312, 230, player, inventory, side);
        this.isDatabase = database;
        this.isMaster = master;
        this.lockedSearch = this.isDatabase;
    }

    public static GeneticsGUI.WindowFactory create(boolean database, boolean master) {
        return (player, inventory, side) -> new WindowAnalyst(player, inventory, side, database, master);
    }

    @Override
    protected AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Analyst";
    }

    private void setupValidators() {
        if (!this.isDatabase) {
            this.getWindowInventory().setValidator(0, new SlotValidator.Individual(){

                @Override
                public boolean isValid(ItemStack itemStack) {
                    return Analyser.isAnalysed(itemStack) || Analyser.isAnalysable(itemStack) && !WindowAnalyst.this.getWindowInventory().func_70301_a(1).func_190926_b();
                }
            });
            this.getWindowInventory().setValidator(1, new SlotValidator.Item(GeneticsItems.DNADye.get(1), ModuleMachine.spriteDye));
        }
    }

    @Override
    public void initialiseServer() {
        for (BreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            IBreedingTracker tracker;
            ISpeciesRoot root = system.getSpeciesRoot();
            if (root == null || (tracker = root.getBreedingTracker(this.getWorld(), this.getUsername())) == null) continue;
            tracker.synchToPlayer(this.getPlayer());
        }
        this.getWindowInventory().createSlot(0);
        this.getWindowInventory().createSlot(1);
        this.setupValidators();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(this.isDatabase ? (this.isMaster ? I18N.localise("genetics.gui.registry.master.title") : I18N.localise("genetics.gui.registry.title")) : I18N.localise("genetics.gui.analyst.title"));
        BreedingSystem system = Binnie.GENETICS.beeBreedingSystem;
        IIndividual ind = system.getDefaultIndividual();
        ItemStack stack = system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType());
        this.getWindowInventory().createSlot(0);
        this.baseWidget = new Widget(this);
        int x = 16;
        int y = 28;
        if (this.isDatabase) {
            for (final BreedingSystem syst : Binnie.GENETICS.getActiveSystems()) {
                new Control(this, x, y, 20, 20){

                    @Override
                    public void initialise() {
                        this.addAttribute(Attribute.MouseOver);
                        this.addSelfEventHandler(new EventMouse.Down.Handler(){

                            @Override
                            @SideOnly(value=Side.CLIENT)
                            public void onEvent(EventMouse.Down event) {
                                WindowAnalyst.this.setSystem(syst);
                            }
                        });
                    }

                    @Override
                    public void getTooltip(Tooltip tooltip) {
                        tooltip.add(syst.getName());
                    }

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        RenderUtil.setColour(syst.getColour());
                        int outset = WindowAnalyst.this.getSystem() == syst ? 1 : 0;
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea().outset(outset));
                        if (WindowAnalyst.this.getSystem() == syst) {
                            RenderUtil.setColour(0x44000000 + syst.getColour());
                            CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().outset(outset));
                        }
                        RenderUtil.drawItem(new Point(2, 2), syst.getItemStackRepresentitive());
                    }
                };
                x += 22;
            }
        } else {
            new ControlSlot.Builder(this, x, y + 1).assign(InventoryType.Window, 0);
            new ControlSlot.Builder(this, x += 22, y + 1).assign(InventoryType.Window, 1);
            x += 26;
            this.setupValidators();
        }
        this.tabBar = new Control(this, x, 28, this.width() - 16 - x, 20);
        this.analystPanel = new Panel(this, 16, 54, 280, 164, MinecraftGUI.PanelType.Outline){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderBackground(int guiWidth, int guiHeight) {
                RenderUtil.drawGradientRect(this.getArea(), 0x44FFFFFF, 0x66FFFFFF);
                super.onRenderBackground(guiWidth, guiHeight);
            }

            @Override
            public void initialise() {
                this.setColor(0x444444);
                int sectionWidth = (this.width() - 8 - 4) / 2;
                WindowAnalyst.this.leftPage = new ControlScrollableContent<IWidget>((IWidget)this, 3, 3, sectionWidth + 2, this.height() - 8 + 2, 0){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        if (this.getContent() == null) {
                            return;
                        }
                        RenderUtil.setColour(this.getContent().getColor());
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    }
                };
                new ControlScrollBar(this, sectionWidth + 2 - 3, 6, 3, this.height() - 8 + 2 - 6, WindowAnalyst.this.leftPage){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        if (!this.isEnabled()) {
                            return;
                        }
                        if (WindowAnalyst.this.leftPage.getContent() == null) {
                            return;
                        }
                        RenderUtil.drawGradientRect(this.getArea(), 0x44000000 + WindowAnalyst.this.leftPage.getContent().getColor(), 0x44000000 + WindowAnalyst.this.leftPage.getContent().getColor());
                        RenderUtil.drawSolidRect(this.getRenderArea(), WindowAnalyst.this.leftPage.getContent().getColor());
                    }
                };
                WindowAnalyst.this.rightPage = new ControlScrollableContent<IWidget>((IWidget)this, 3 + sectionWidth + 4, 3, sectionWidth + 2, this.height() - 8 + 2, 0){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        if (this.getContent() == null) {
                            return;
                        }
                        RenderUtil.setColour(this.getContent().getColor());
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    }
                };
                new ControlScrollBar(this, sectionWidth + 2 - 3 + sectionWidth + 4, 6, 3, this.height() - 8 + 2 - 6, WindowAnalyst.this.rightPage){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        if (!this.isEnabled()) {
                            return;
                        }
                        if (WindowAnalyst.this.rightPage.getContent() == null) {
                            return;
                        }
                        RenderUtil.drawGradientRect(this.getArea(), 0x44000000 + WindowAnalyst.this.rightPage.getContent().getColor(), 0x44000000 + WindowAnalyst.this.rightPage.getContent().getColor());
                        RenderUtil.drawSolidRect(this.getRenderArea(), WindowAnalyst.this.rightPage.getContent().getColor());
                    }
                };
                WindowAnalyst.this.analystPageSize = new Area(1, 1, sectionWidth, this.height() - 8);
            }
        };
        if (!this.isDatabase) {
            this.slideUpInv = new ControlSlide(this, (this.getSize().x() - 244) / 2, this.getSize().y() - 80 + 1, 244, 80, Position.BOTTOM);
            new ControlPlayerInventory((IWidget)this.slideUpInv, true);
            this.slideUpInv.setSlide(false);
        }
        this.addEventHandler(new EventKey.Down.Handler(){

            @Override
            public void onEvent(EventKey.Down event) {
                if (event.getKey() == 205) {
                    WindowAnalyst.this.shiftPages(true);
                }
                if (event.getKey() == 203) {
                    WindowAnalyst.this.shiftPages(false);
                }
            }
        });
        if (!this.isDatabase) {
            this.analystNone = new Control(this.analystPanel, 0, 0, this.analystPanel.width(), this.analystPanel.height()){

                @Override
                public void initialise() {
                    new ControlTextCentered((IWidget)this, 20, I18N.localise("genetics.gui.analyst.desc")).setColor(0x444444);
                    new ControlPlayerInventory(this);
                }
            };
        }
        this.setIndividual(null);
        this.setSystem(Binnie.GENETICS.beeBreedingSystem);
    }

    @SideOnly(value=Side.CLIENT)
    public void updatePages(boolean systemChange) {
        int oldLeft = -1;
        int oldRight = -1;
        if (!systemChange) {
            oldLeft = this.analystPages.indexOf(this.leftPage.getContent());
            oldRight = this.analystPages.indexOf(this.rightPage.getContent());
        }
        ControlAnalystPage databasePage = null;
        if (this.isDatabase && !systemChange) {
            databasePage = this.analystPages.size() > 0 ? this.analystPages.get(0) : null;
        }
        this.analystPages.clear();
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        if (this.isDatabase) {
            this.analystPages.add(databasePage != null ? databasePage : new AnalystPageDatabase(this.analystPanel, this.analystPageSize, this.currentSystem, this.isMaster));
        }
        if (this.current != null) {
            this.analystPages.add(new AnalystPageDescription(this.analystPanel, this.analystPageSize, this.current));
            this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, true, this.current));
            if (!this.isDatabase) {
                this.analystPages.add(new AnalystPageGenome(this.analystPanel, this.analystPageSize, false, this.current));
                this.analystPages.add(new AnalystPageKaryogram(this.analystPanel, this.analystPageSize, this.current));
            }
            if (!(this.current instanceof ITree)) {
                this.analystPages.add(new AnalystPageClimate(this.analystPanel, this.analystPageSize, this.current));
            }
            if (this.current instanceof IBee) {
                this.analystPages.add(new AnalystPageProducts(this.analystPanel, this.analystPageSize, (IBee)this.current));
            } else if (this.current instanceof ITree) {
                this.analystPages.add(new AnalystPageFruit(this.analystPanel, this.analystPageSize, (ITree)this.current));
                this.analystPages.add(new AnalystPageWood(this.analystPanel, this.analystPageSize, (ITree)this.current));
            } else if (this.current instanceof IFlower) {
                this.analystPages.add(new AnalystPageSoil(this.analystPanel, this.analystPageSize, (IFlower)this.current));
            } else if (this.current instanceof IButterfly) {
                this.analystPages.add(new AnalystPageSpecimen(this.analystPanel, this.analystPageSize, (IButterfly)this.current));
            }
            this.analystPages.add(new AnalystPageBiology(this.analystPanel, this.analystPageSize, this.current));
            if (this.current instanceof IBee || this.current instanceof IButterfly) {
                this.analystPages.add(new AnalystPageBehaviour(this.analystPanel, this.analystPageSize, this.current));
            } else if (this.current instanceof ITree) {
                this.analystPages.add(new AnalystPageGrowth(this.analystPanel, this.analystPageSize, this.current));
            } else if (this.current instanceof IFlower) {
                this.analystPages.add(new AnalystPageAppearance(this.analystPanel, this.analystPageSize, (IFlower)this.current));
            }
            this.analystPages.add(new AnalystPageMutations(this.analystPanel, this.analystPageSize, this.current, this.isMaster));
        }
        this.tabBar.deleteAllChildren();
        if (this.analystPages.size() > 0) {
            int width = this.tabBar.width() / this.analystPages.size();
            int x = 0;
            for (final ControlAnalystPage page : this.analystPages) {
                new ControlTooltip(this.tabBar, x, 0, width, this.tabBar.height()){
                    ControlAnalystPage value;

                    @Override
                    public void getTooltip(Tooltip tooltip) {
                        tooltip.add(this.value.getTitle());
                    }

                    @Override
                    protected void initialise() {
                        super.initialise();
                        this.addAttribute(Attribute.MouseOver);
                        this.value = page;
                        this.addSelfEventHandler(new EventMouse.Down.Handler(){

                            @Override
                            public void onEvent(EventMouse.Down event) {
                                int currentIndex = WindowAnalyst.this.analystPages.indexOf(WindowAnalyst.this.rightPage.getContent());
                                int clickedIndex = WindowAnalyst.this.analystPages.indexOf(value);
                                if (WindowAnalyst.this.isDatabase) {
                                    if (clickedIndex != 0 && clickedIndex != currentIndex) {
                                        WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, value);
                                    }
                                } else {
                                    if (clickedIndex < 0) {
                                        clickedIndex = 0;
                                    }
                                    if (clickedIndex < currentIndex) {
                                        ++clickedIndex;
                                    }
                                    WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, null);
                                    WindowAnalyst.this.setPage(WindowAnalyst.this.leftPage, null);
                                    WindowAnalyst.this.setPage(WindowAnalyst.this.rightPage, WindowAnalyst.this.analystPages.get(clickedIndex));
                                    WindowAnalyst.this.setPage(WindowAnalyst.this.leftPage, WindowAnalyst.this.analystPages.get(clickedIndex - 1));
                                }
                            }
                        });
                    }

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void onRenderBackground(int guiWidth, int guiHeight) {
                        boolean active = this.value == WindowAnalyst.this.leftPage.getContent() || this.value == WindowAnalyst.this.rightPage.getContent();
                        RenderUtil.setColour((active ? -16777216 : 0x44000000) + this.value.getColor());
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179147_l();
                        CraftGUI.render.texture((Object)CraftGUITexture.TabSolid, this.getArea().inset(1));
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179121_F();
                        RenderUtil.setColour(this.value.getColor());
                        CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea().inset(1));
                        super.onRenderBackground(guiWidth, guiHeight);
                    }
                };
                x += width;
            }
            this.setPage(this.leftPage, this.analystPages.get(oldLeft >= 0 ? oldLeft : 0));
            if (this.analystPages.size() > 1) {
                this.setPage(this.rightPage, this.analystPages.get(oldRight >= 0 ? oldRight : 1));
            }
        }
    }

    public void shiftPages(boolean right) {
        if (this.analystPages.size() < 2) {
            return;
        }
        int leftIndex = this.analystPages.indexOf(this.leftPage.getContent());
        int rightIndex = this.analystPages.indexOf(this.rightPage.getContent());
        if (right && rightIndex + 1 >= this.analystPages.size()) {
            return;
        }
        if (!this.lockedSearch && !right && leftIndex <= 0) {
            return;
        }
        if (!this.lockedSearch && !right && rightIndex <= 1) {
            return;
        }
        int newRightIndex = rightIndex + (right ? 1 : -1);
        int newLeftIndex = this.lockedSearch ? 0 : newRightIndex - 1;
        float oldRightPercent = 0.0f;
        float oldLeftPercent = 0.0f;
        if (newLeftIndex == rightIndex) {
            oldRightPercent = this.rightPage.getPercentageIndex();
        }
        if (newRightIndex == leftIndex) {
            oldLeftPercent = this.leftPage.getPercentageIndex();
        }
        this.setPage(this.leftPage, null);
        this.setPage(this.rightPage, null);
        this.setPage(this.leftPage, this.analystPages.get(newLeftIndex));
        this.setPage(this.rightPage, this.analystPages.get(newRightIndex));
        this.analystPages.get(newLeftIndex).show();
        if (oldRightPercent != 0.0f) {
            this.leftPage.setPercentageIndex(oldRightPercent);
        }
        if (oldLeftPercent != 0.0f) {
            this.rightPage.setPercentageIndex(oldLeftPercent);
        }
    }

    public void setPage(ControlScrollableContent side, @Nullable ControlAnalystPage page) {
        ControlAnalystPage existingPage = (ControlAnalystPage)side.getContent();
        if (existingPage != null) {
            existingPage.hide();
            side.setScrollableContent(null);
        }
        if (page != null) {
            page.show();
            side.setScrollableContent(page);
            side.setPercentageIndex(0.0f);
            page.setPosition(side.pos().add(1, 1));
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        super.onWindowInventoryChanged();
        WindowInventory inv = this.getWindowInventory();
        ItemStack stack = inv.func_70301_a(0);
        if (!stack.func_190926_b() && !Analyser.isAnalysed(stack)) {
            inv.func_70299_a(0, Analyser.analyse(stack, this.getWorld(), this.getUsername()));
            inv.func_70298_a(1, 1);
        }
        if (this.isClient()) {
            this.setStack(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setStack(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        this.setIndividual(ind);
    }

    public IIndividual getIndividual() {
        return this.current;
    }

    @SideOnly(value=Side.CLIENT)
    public void setIndividual(IIndividual ind) {
        boolean systemChange;
        if (!this.isDatabase) {
            if (ind == null) {
                this.analystNone.show();
                this.slideUpInv.hide();
            } else {
                this.analystNone.hide();
                this.slideUpInv.show();
            }
        }
        if (ind == this.current || ind != null && this.current != null && ind.isGeneticEqual(this.current)) {
            return;
        }
        this.current = ind;
        boolean bl = systemChange = this.current != null && ind.getGenome().getSpeciesRoot() != this.getSystem().getSpeciesRoot();
        if (systemChange) {
            this.currentSystem = Binnie.GENETICS.getSystem(ind.getGenome().getSpeciesRoot());
        }
        this.updatePages(systemChange);
    }

    public BreedingSystem getSystem() {
        return this.currentSystem;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSystem(BreedingSystem system) {
        if (system == this.currentSystem) {
            return;
        }
        this.currentSystem = system;
        this.current = null;
        this.updatePages(true);
    }
}

