/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.UniqueFluidStackSet;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.machines.brewery.BreweryRecipes;
import binnie.extratrees.machines.distillery.DistilleryRecipes;
import binnie.extratrees.machines.fruitpress.FruitPressRecipes;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.bee.AnalystPageProducts;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public abstract class AnalystPageProduce
extends ControlAnalystPage {
    public AnalystPageProduce(IWidget parent, Area area) {
        super(parent, area);
    }

    protected Collection<? extends ItemStack> getAllProducts(ItemStack key) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        products.addAll(this.getCentrifuge(key));
        products.addAll(this.getSqueezer(key));
        products.add(FurnaceRecipes.func_77602_a().func_151395_a(key));
        products.addAll(this.getCrafting(key));
        return products;
    }

    public Collection<ItemStack> getCentrifuge(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            boolean isRecipe = false;
            if (stack.func_77969_a(recipe.getInput())) {
                isRecipe = true;
            }
            if (!isRecipe) continue;
            for (Object obj : recipe.getAllProducts().keySet()) {
                if (!(obj instanceof ItemStack)) continue;
                products.add((ItemStack)obj);
            }
        }
        return products;
    }

    public NonNullList<ItemStack> getSqueezer(ItemStack stack) {
        NonNullList products = NonNullList.func_191196_a();
        for (ISqueezerRecipe recipe : RecipeManagers.squeezerManager.recipes()) {
            boolean isRecipe = false;
            for (Object obj : recipe.getResources()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe || recipe.getRemnants().func_190926_b()) continue;
            products.add((Object)recipe.getRemnants());
        }
        return products;
    }

    public Collection<ItemStack> getCrafting(ItemStack stack) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Object recipeO : CraftingManager.func_77594_a().func_77592_b()) {
            boolean match;
            if (recipeO instanceof ShapelessRecipes) {
                ShapelessRecipes recipe = (ShapelessRecipes)recipeO;
                match = true;
                for (Object rec : recipe.field_77579_b) {
                    if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe.func_77571_b());
                }
            }
            if (recipeO instanceof ShapedRecipes) {
                ShapedRecipes recipe2 = (ShapedRecipes)recipeO;
                match = true;
                for (ItemStack rec2 : recipe2.field_77574_d) {
                    if (rec2 == null || rec2 instanceof ItemStack && stack.func_77969_a(rec2)) continue;
                    match = false;
                }
                if (match) {
                    products.add(recipe2.func_77571_b());
                }
            }
            if (!(recipeO instanceof ShapelessOreRecipe)) continue;
            ShapelessOreRecipe recipe3 = (ShapelessOreRecipe)recipeO;
            match = true;
            for (Object rec : recipe3.getInput()) {
                if (rec == null || rec instanceof ItemStack && stack.func_77969_a((ItemStack)rec)) continue;
                match = false;
            }
            if (!match) continue;
            products.add(recipe3.func_77571_b());
        }
        return products;
    }

    public Collection<FluidStack> getAllFluids(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        products.addAll(this.getSqueezerFluid(stack));
        if (FruitPressRecipes.getOutput(stack) != null) {
            products.add(FruitPressRecipes.getOutput(stack));
        }
        return products;
    }

    public Collection<FluidStack> getSqueezerFluid(ItemStack stack) {
        ArrayList<FluidStack> products = new ArrayList<FluidStack>();
        for (ISqueezerRecipe recipe : RecipeManagers.squeezerManager.recipes()) {
            boolean isRecipe = false;
            for (Object obj : recipe.getResources()) {
                if (!(obj instanceof ItemStack) || !stack.func_77969_a((ItemStack)obj)) continue;
                isRecipe = true;
            }
            if (!isRecipe) continue;
            products.add(recipe.getFluidOutput());
        }
        return products;
    }

    protected Collection<? extends FluidStack> getAllProducts(FluidStack stack) {
        UniqueFluidStackSet fluids = new UniqueFluidStackSet();
        fluids.add(BreweryRecipes.getOutput(stack));
        fluids.add(DistilleryRecipes.getOutput(stack, 0));
        fluids.add(DistilleryRecipes.getOutput(stack, 1));
        fluids.add(DistilleryRecipes.getOutput(stack, 2));
        return fluids;
    }

    protected Collection<ItemStack> getAllProductsAndFluids(Collection<ItemStack> collection) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack itemStack : collection) {
            products.addAll(this.getAllProducts(itemStack));
        }
        UniqueItemStackSet products2 = new UniqueItemStackSet();
        for (Object stack2 : products) {
            products2.addAll(this.getAllProducts((ItemStack)stack2));
        }
        UniqueItemStackSet uniqueItemStackSet = new UniqueItemStackSet();
        for (Object stack3 : products2) {
            uniqueItemStackSet.addAll(this.getAllProducts((ItemStack)stack3));
        }
        products.addAll(products2);
        products.addAll(uniqueItemStackSet);
        UniqueFluidStackSet allFluids = new UniqueFluidStackSet();
        for (ItemStack itemStack : collection) {
            allFluids.addAll(this.getAllFluids(itemStack));
        }
        UniqueFluidStackSet fluids2 = new UniqueFluidStackSet();
        for (FluidStack stack5 : allFluids) {
            fluids2.addAll(this.getAllProducts(stack5));
        }
        UniqueFluidStackSet uniqueFluidStackSet = new UniqueFluidStackSet();
        for (FluidStack stack6 : fluids2) {
            uniqueFluidStackSet.addAll(this.getAllProducts(stack6));
        }
        allFluids.addAll(fluids2);
        allFluids.addAll(uniqueFluidStackSet);
        for (FluidStack fluid : allFluids) {
            ItemStack container = AnalystPageProducts.getContainer(fluid);
            if (container == null) continue;
            products.add(container);
        }
        return products;
    }

    protected int getRefined(String string, int y, Collection<ItemStack> products) {
        new ControlTextCentered((IWidget)this, y, string).setColor(this.getColor());
        y += 10;
        int maxBiomePerLine = (this.width() + 2 - 16) / 18;
        int biomeListX = (this.width() - (Math.min(maxBiomePerLine, products.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : products) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)soilStack);
            soilStack.func_190920_e(1);
            ControlItemDisplay display = new ControlItemDisplay((IWidget)this, biomeListX + dx, y + dy, soilStack, fluid == null);
            if (fluid != null) {
                display.addTooltip(fluid.getLocalizedName());
            }
            dx += 18;
        }
        if (dx != 0) {
            dy += 18;
        }
        return y += dy;
    }
}

