/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.component.ComponentRecipe;
import binnie.core.machines.component.IComponentRecipe;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.DesignerType;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.Validators;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Designer {
    public static int beeswaxSlot = 0;
    public static int design1Slot = 1;
    public static int design2Slot = 2;

    public static class ComponentWoodworkerRecipe
    extends ComponentRecipe
    implements IComponentRecipe,
    INetwork.GuiNBT,
    IErrorStateSource {
        public DesignerType type;
        private IDesign design = EnumDesign.Diamond;

        public ComponentWoodworkerRecipe(Machine machine, DesignerType type) {
            super(machine);
            this.type = type;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            super.readFromNBT(nbttagcompound);
            this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbttagcompound.func_74762_e("design")));
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound1) {
            NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound1);
            nbttagcompound.func_74768_a("design", CarpentryManager.carpentryInterface.getDesignIndex(this.design));
            return nbttagcompound;
        }

        @Override
        public boolean isRecipe() {
            return !this.getProduct().func_190926_b();
        }

        @Override
        public ItemStack getProduct() {
            ItemStack plank1 = this.getUtil().getStack(design1Slot);
            ItemStack plank2 = this.getUtil().getStack(design2Slot);
            if (plank1.func_190926_b() || plank2.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            IDesignMaterial type1 = this.type.getSystem().getMaterial(plank1);
            IDesignMaterial type2 = this.type.getSystem().getMaterial(plank2);
            IDesign design = this.getDesign();
            return this.type.getBlock(type1, type2, design);
        }

        @Override
        public ItemStack doRecipe(boolean takeItem) {
            if (!this.isRecipe()) {
                return ItemStack.field_190927_a;
            }
            if (this.canWork() != null) {
                return ItemStack.field_190927_a;
            }
            ItemStack product = this.getProduct();
            if (takeItem) {
                ItemStack a = this.getUtil().decreaseStack(design1Slot, 1);
                if (a.func_190926_b()) {
                    this.getUtil().decreaseStack(design2Slot, 1);
                } else if (this.design != EnumDesign.Blank) {
                    this.getUtil().decreaseStack(design2Slot, 1);
                }
                this.getUtil().decreaseStack(beeswaxSlot, 1);
            }
            return product;
        }

        public IDesign getDesign() {
            return this.design;
        }

        private void setDesign(IDesign design) {
            this.design = design;
        }

        @Override
        @Nullable
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(beeswaxSlot)) {
                return new ErrorState.NoItem("Requires Adhesive to Function", beeswaxSlot);
            }
            return null;
        }

        @Override
        @Nullable
        public ErrorState canProgress() {
            return null;
        }

        @Override
        public void sendGuiNBTToClient(Map<String, NBTTagCompound> nbt) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("d", (short)CarpentryManager.carpentryInterface.getDesignIndex(this.getDesign()));
            nbt.put("design", tag);
        }

        @Override
        public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
            if (name.equals("design")) {
                this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74765_d("d")));
            }
        }

        @Override
        public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
            if (name.equals("recipe")) {
                InventoryPlayer playerInv = player.field_71071_by;
                ItemStack recipe = this.doRecipe(false);
                if (!recipe.func_190926_b()) {
                    int fit;
                    if (playerInv.func_70445_o().func_190926_b()) {
                        playerInv.func_70437_b(this.doRecipe(true));
                    } else if (playerInv.func_70445_o().func_77969_a(recipe) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)recipe) && (fit = recipe.func_77976_d() - (recipe.func_190916_E() + playerInv.func_70445_o().func_190916_E())) >= 0) {
                        this.doRecipe(true);
                        recipe.func_190917_f(playerInv.func_70445_o().func_190916_E());
                        playerInv.func_70437_b(recipe);
                    }
                    player.field_71070_bA.func_75142_b();
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71113_k();
                    }
                }
            } else if (name.equals("design")) {
                this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74762_e("d")));
            }
        }

        public DesignerType getDesignerType() {
            return this.type;
        }
    }

    public static abstract class PackageCarpenter
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        DesignerType type;

        public PackageCarpenter(DesignerType type) {
            super(type.name, type.texture, false);
            this.type = type;
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Woodworker);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(beeswaxSlot, "polish").setValidator(new Validators.SlotValidatorBeeswax(this.type));
            inventory.addSlot(design1Slot, "wood").setValidator(new Validators.SlotValidatorPlanks(this.type));
            inventory.addSlot(design2Slot, "wood").setValidator(new Validators.SlotValidatorPlanks(this.type));
            new ComponentWoodworkerRecipe(machine, this.type);
        }
    }

    public static class PackageTileworker
    extends PackageCarpenter {
        public PackageTileworker() {
            super(DesignerType.Tileworker);
        }
    }

    public static class PackageGlassworker
    extends PackageCarpenter {
        public PackageGlassworker() {
            super(DesignerType.GlassWorker);
        }
    }

    public static class PackagePanelworker
    extends PackageCarpenter {
        public PackagePanelworker() {
            super(DesignerType.Panelworker);
        }
    }

    public static class PackageWoodworker
    extends PackageCarpenter {
        public PackageWoodworker() {
            super(DesignerType.Woodworker);
        }
    }
}

