/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.machines;

import binnie.core.AbstractMod;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlErrorState;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.window.Panel;
import binnie.core.machines.Machine;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.gui.machines.ControlRecipeSlot;
import binnie.extratrees.gui.machines.ControlTileSelect;
import binnie.extratrees.machines.Designer;
import binnie.extratrees.machines.DesignerType;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowWoodworker
extends Window {
    ControlTextEdit textEdit;
    ControlTileSelect tileSelect;

    public WindowWoodworker(EntityPlayer player, IInventory inventory, Side side) {
        super(320, 216, player, inventory, side);
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                WindowWoodworker.this.tileSelect.refresh((String)event.getValue());
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
    }

    @Nullable
    public static Window create(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        if (inventory == null) {
            return null;
        }
        return new WindowWoodworker(player, inventory, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        new ControlText(this, new Area(190, 36, 114, 10), I18N.localise("binniecore.gui.design"), TextJustification.TOP_CENTER).setColor(0x444444);
        new Panel(this, 188, 48, 118, 126, MinecraftGUI.PanelType.Gray);
        this.textEdit = new ControlTextEdit(this, 188, 178, 118, 12);
        ControlScrollableContent<ControlTileSelect> scroll = new ControlScrollableContent<ControlTileSelect>(this, 190, 50, 114, 122, 12);
        this.tileSelect = new ControlTileSelect(scroll, 0, 0);
        scroll.setScrollableContent(this.tileSelect);
        new ControlPlayerInventory(this).setPosition(new Point(14, 96));
        new ControlErrorState(this, 76, 65);
        if (this.getInventory() != null) {
            ControlSlot slotWood1 = new ControlSlot.Builder(this, 22, 34).assign(Designer.design1Slot);
            ControlSlot slotWood2 = new ControlSlot.Builder(this, 62, 34).assign(Designer.design2Slot);
            ControlSlot slotBeeswax = new ControlSlot.Builder(this, 42, 64).assign(Designer.beeswaxSlot);
            ControlRecipeSlot controlRecipeSlot = new ControlRecipeSlot(this, 112, 34);
        }
    }

    @Override
    protected AbstractMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Woodworker";
    }

    public DesignerType getDesignerType() {
        return Machine.getInterface(Designer.ComponentWoodworkerRecipe.class, this.getInventory()).getDesignerType();
    }
}

