package binnie.core.gui.minecraft;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

import binnie.core.machines.inventory.SlotValidator;

public class WindowInventory implements IInventory {
	private Window window;
	private Map<Integer, ItemStack> inventory;
	private Map<Integer, SlotValidator> validators;
	private List<Integer> disabledAutoDispenses;

	public WindowInventory(final Window window) {
		this.inventory = new HashMap<>();
		this.validators = new HashMap<>();
		this.disabledAutoDispenses = new ArrayList<>();
		this.window = window;
	}

	@Override
	public int func_70302_i_() {
		if (this.inventory.size() == 0) {
			return 0;
		}
		int max = 0;
		for (final int i : this.inventory.keySet()) {
			if (i > max) {
				max = i;
			}
		}
		return max + 1;
	}

	@Override
	public boolean func_191420_l() {
		return this.inventory.isEmpty();
	}

	@Override
	public ItemStack func_70301_a(final int var1) {
		if (this.inventory.containsKey(var1)) {
			return this.inventory.get(var1);
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(final int index, int amount) {
		if (this.inventory.containsKey(index)) {
			final ItemStack item = this.inventory.get(index);
			final ItemStack output = item.func_77946_l();
			final int available = item.func_190916_E();
			if (amount > available) {
				amount = available;
			}
			item.func_190918_g(amount);
			output.func_190920_e(amount);
			if (item.func_190926_b()) {
				this.func_70299_a(index, ItemStack.field_190927_a);
			}
			return output;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public void func_70299_a(final int index, final ItemStack stack) {
		this.inventory.put(index, stack);
		this.func_70296_d();
	}

	@Override
	public int func_70297_j_() {
		return 64;
	}

	@Override
	public void func_70296_d() {
		this.window.onWindowInventoryChanged();
	}

	@Override
	public boolean func_70300_a(final EntityPlayer var1) {
		return true;
	}

	@Override
	public boolean func_94041_b(final int i, final ItemStack itemstack) {
		return !this.validators.containsKey(i) || this.validators.get(i).isValid(itemstack);
	}

	public void createSlot(final int slot) {
		this.inventory.put(slot, ItemStack.field_190927_a);
	}

	public void setValidator(final int slot, final SlotValidator validator) {
		this.validators.put(slot, validator);
	}

	public void disableAutoDispense(final int i) {
		this.disabledAutoDispenses.add(i);
	}

	public boolean dispenseOnClose(final int i) {
		return !this.disabledAutoDispenses.contains(i);
	}

	@Nullable
	public SlotValidator getValidator(final int i) {
		return this.validators.get(i);
	}

	@Override
	public boolean func_145818_k_() {
		return false;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {

	}

	@Override
	public void func_174886_c(EntityPlayer player) {

	}

	@Override
	public String func_70005_c_() {
		return "window.inventory";
	}

	@Override
	public void func_174888_l() {
		this.inventory.clear();
	}

	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {

	}

	@Override
	public ItemStack func_70304_b(int index) {
		return this.inventory.remove(index);
	}

	@Override
	public ITextComponent func_145748_c_() {
		return new TextComponentString("Inventory");
	}
}
