/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.fieldkit;

import binnie.Binnie;
import binnie.core.ExtraBeeTexture;
import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.fieldkit.ControlChromosome;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.resource.Texture;
import binnie.core.craftgui.resource.minecraft.StandardTexture;
import forestry.api.genetics.IChromosomeType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlChromoPicker
extends Control
implements ITooltip {
    Texture Selected = new StandardTexture(160, 18, 16, 16, ExtraBeeTexture.GUIPunnett);
    Texture Texture = new StandardTexture(160, 34, 16, 16, ExtraBeeTexture.GUIPunnett);
    IChromosomeType type;
    ControlChromosome parent;

    public ControlChromoPicker(ControlChromosome parent, int x, int y, IChromosomeType chromo) {
        super(parent, x, y, 16, 16);
        this.type = chromo;
        this.addAttribute(Attribute.MouseOver);
        this.parent = parent;
        this.addSelfEventHandler(new EventWidget.StartMouseOver.Handler(){

            @Override
            public void onEvent(EventWidget.StartMouseOver event) {
                ControlChromoPicker.this.callEvent(new EventValueChanged<IChromosomeType>(ControlChromoPicker.this.getWidget(), ControlChromoPicker.this.type));
            }
        });
        this.addSelfEventHandler(new EventWidget.EndMouseOver.Handler(){

            @Override
            public void onEvent(EventWidget.EndMouseOver event) {
                ControlChromoPicker.this.callEvent(new EventValueChanged<Object>(ControlChromoPicker.this.getWidget(), null));
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        boolean selected = this.isMouseOver();
        Texture text = selected ? this.Selected : this.Texture;
        CraftGUI.render.texture(text, Point.ZERO);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(Binnie.GENETICS.getSystem(this.parent.getRoot()).getChromosomeName(this.type));
    }
}

