/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.ExtraBeeTexture;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.fieldkit.ControlChromosome;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlImage;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.resource.StyleSheetPunnett;
import binnie.core.craftgui.resource.minecraft.StandardTexture;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.util.I18N;
import binnie.genetics.machine.analyser.Analyser;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowFieldKit
extends Window {
    private int glassOffsetX = 0;
    private int glassOffsetY = 0;
    private int glassVX = 0;
    private int glassVY = 0;
    private Random glassRand = new Random();
    private Control GlassControl;
    private ControlChromosome chromo;
    private ControlText text;
    private float analyseProgress = 1.0f;
    private boolean isAnalysing = false;
    private Map<IChromosomeType, String> info = new HashMap<IChromosomeType, String>();

    public WindowFieldKit(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        super(280, 230, player, inventory, side);
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.getInstance();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Field Kit";
    }

    private void setupValidators() {
        this.getWindowInventory().setValidator(0, new SlotValidator(null){

            @Override
            public boolean isValid(ItemStack object) {
                return AlleleManager.alleleRegistry.isIndividual(object) || Binnie.GENETICS.getConversion(object) != null;
            }

            @Override
            public String getTooltip() {
                return "Individual";
            }
        });
        this.getWindowInventory().setValidator(1, new SlotValidator(null){

            @Override
            public boolean isValid(ItemStack object) {
                return object.func_77973_b() == Items.field_151121_aF;
            }

            @Override
            public String getTooltip() {
                return "Paper";
            }
        });
        this.getWindowInventory().disableAutoDispense(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle("Field Kit");
        CraftGUI.render.setStyleSheet(new StyleSheetPunnett());
        this.getWindowInventory().createSlot(0);
        this.getWindowInventory().createSlot(1);
        this.setupValidators();
        new ControlPlayerInventory(this);
        Point handGlass = new Point(16, 32);
        this.GlassControl = new ControlImage(this, handGlass.x(), handGlass.y(), new StandardTexture(0, 160, 96, 96, ExtraBeeTexture.GUIPunnett));
        new ControlSlot.Builder(this, handGlass.x() + 54, handGlass.y() + 26).assign(InventoryType.Window, 0);
        new ControlSlot.Builder(this, 208, 8).assign(InventoryType.Window, 1);
        this.text = new ControlText((IWidget)this, new Point(232, 13), "Paper");
        this.text.setColor(0x222222);
        this.text = new ControlText(this, new Area(0, 120, this.width(), 24), "", TextJustification.MIDDLE_CENTER);
        this.text.setColor(0x222222);
        this.chromo = new ControlChromosome(this, 150, 24);
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IChromosomeType type = (IChromosomeType)event.getValue();
                if (type != null && WindowFieldKit.this.info.containsKey(type)) {
                    String t = (String)WindowFieldKit.this.info.get(type);
                    WindowFieldKit.this.text.setValue(t);
                } else {
                    WindowFieldKit.this.text.setValue("");
                }
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this.chromo));
    }

    @Override
    public void initialiseServer() {
        ItemStack kit = this.getPlayer().func_184614_ca();
        int sheets = 64 - kit.func_77952_i();
        this.getWindowInventory().createSlot(0);
        this.getWindowInventory().createSlot(1);
        if (sheets != 0) {
            this.getWindowInventory().func_70299_a(1, new ItemStack(Items.field_151121_aF, sheets));
        }
        this.setupValidators();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.isAnalysing) {
            this.analyseProgress += 0.01f;
            if (this.analyseProgress >= 1.0f) {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                ItemStack stack = this.getWindowInventory().func_70301_a(0);
                if (!stack.func_190926_b()) {
                    this.sendClientAction("analyse", new NBTTagCompound());
                }
                this.refreshSpecies();
            }
        }
        this.glassVX = (int)((float)this.glassVX + (this.glassRand.nextFloat() - 0.5f - (float)this.glassOffsetX * 0.2f));
        this.glassVY = (int)((float)this.glassVY + (this.glassRand.nextFloat() - 0.5f - (float)this.glassOffsetY * 0.2f));
        this.glassOffsetX += this.glassVX;
        this.glassOffsetX = (int)((float)this.glassOffsetX * (1.0f - this.analyseProgress));
        this.glassOffsetY += this.glassVY;
        this.glassOffsetY = (int)((float)this.glassOffsetY * (1.0f - this.analyseProgress));
        this.GlassControl.setOffset(new Point(this.glassOffsetX, this.glassOffsetY));
    }

    private void refreshSpecies() {
        ItemStack item = this.getWindowInventory().func_70301_a(0);
        if (item.func_190926_b() || !AlleleManager.alleleRegistry.isIndividual(item)) {
            return;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(item);
        if (ind == null) {
            return;
        }
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(item);
        this.chromo.setRoot(root);
        Random rand = new Random();
        this.info.clear();
        for (IChromosomeType type : root.getKaryotype()) {
            if (Binnie.GENETICS.isInvalidChromosome(type)) continue;
            IAllele allele = ind.getGenome().getActiveAllele(type);
            ArrayList<String> infos = new ArrayList<String>();
            int i = 0;
            String pref = root.getUID() + ".fieldkit." + type.getName().toLowerCase() + ".";
            while (I18N.canLocalise(pref + i)) {
                infos.add(I18N.localise(pref + i));
                ++i;
            }
            String text = Binnie.GENETICS.getSystem(root).getAlleleName(type, allele);
            if (!infos.isEmpty()) {
                text = (String)infos.get(rand.nextInt(infos.size()));
            }
            this.info.put(type, text);
            this.chromo.setRoot(root);
        }
    }

    @Override
    public void onWindowInventoryChanged() {
        super.onWindowInventoryChanged();
        if (this.isServer()) {
            int size;
            ItemStack kit = this.getPlayer().func_184614_ca();
            int sheets = 64 - kit.func_77952_i();
            int n = size = this.getWindowInventory().func_70301_a(1) == null ? 0 : this.getWindowInventory().func_70301_a(1).func_190916_E();
            if (sheets != size) {
                kit.func_77964_b(64 - size);
            }
            ((EntityPlayerMP)this.getPlayer()).func_71113_k();
        }
        if (this.isClient()) {
            ItemStack item = this.getWindowInventory().func_70301_a(0);
            this.text.setValue("");
            if (!item.func_190926_b() && !Analyser.isAnalysed(item)) {
                if (this.getWindowInventory().func_70301_a(1).func_190926_b()) {
                    this.text.setValue("No Paper!");
                    this.isAnalysing = false;
                    this.analyseProgress = 1.0f;
                } else {
                    this.startAnalysing();
                    this.chromo.setRoot(null);
                    if (this.damageKit()) {
                        return;
                    }
                }
            } else if (!item.func_190926_b()) {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                this.refreshSpecies();
                if (this.damageKit()) {
                    return;
                }
            } else {
                this.isAnalysing = false;
                this.analyseProgress = 1.0f;
                this.chromo.setRoot(null);
            }
        }
    }

    private boolean damageKit() {
        return false;
    }

    private void startAnalysing() {
        this.glassVX = 0;
        this.glassVY = 0;
        this.glassOffsetX = 0;
        this.glassOffsetY = 0;
        this.isAnalysing = true;
        this.analyseProgress = 0.0f;
    }

    @Override
    public boolean showHelpButton() {
        return true;
    }

    @Override
    public String showInfoButton() {
        return "The Field Kit analyses bees, trees, flowers and butterflies. All that is required is a piece of paper to jot notes";
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        super.receiveGuiNBTOnServer(player, name, nbt);
        if (name.equals("analyse")) {
            this.getWindowInventory().func_70299_a(0, Analyser.analyse(this.getWindowInventory().func_70301_a(0), this.getWorld(), this.getUsername()));
            this.getWindowInventory().func_70298_a(1, 1);
        }
    }
}

