package binnie.extratrees.item;

import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

import net.minecraftforge.fml.common.registry.GameRegistry;

import forestry.api.core.Tabs;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.IStillManager;
import forestry.api.recipes.RecipeManagers;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.IInitializable;
import binnie.core.Mods;
import binnie.core.item.ItemMisc;
import binnie.core.liquid.ManagerLiquid;
import binnie.extratrees.ExtraTrees;

public class ModuleItems implements IInitializable {

	public Item itemDictionary;
	public Item itemDictionaryLepi;
	public ItemMisc itemMisc;
	public Item itemFood;
	public Item itemHammer;
	public Item itemDurableHammer;
	public Item itemHops;

	@Override
	public void preInit() {
		itemMisc = new ItemMisc(Tabs.tabArboriculture, ExtraTreeItems.values());
		ExtraTrees.proxy.registerItem(itemMisc);

		itemDictionary = new ItemArboristDatabase();
		ExtraTrees.proxy.registerItem(itemDictionary);

		if (BinnieCore.isLepidopteryActive()) {
			itemDictionaryLepi = new ItemMothDatabase();
			ExtraTrees.proxy.registerItem(itemDictionaryLepi);
		}
		Binnie.LIQUID.createLiquids(ExtraTreeLiquid.values());
		itemFood = new ItemETFood();
		ExtraTrees.proxy.registerItem(itemFood);

		itemHammer = new ItemHammer(false);
		ExtraTrees.proxy.registerItem(itemHammer);
		itemDurableHammer = new ItemHammer(true);
		ExtraTrees.proxy.registerItem(itemDurableHammer);
		
		itemHops = new ItemHops(ExtraTrees.blocks().hops, Blocks.field_150458_ak);
		ExtraTrees.proxy.registerItem(itemHops);
		
		OreDictionary.registerOre("pulpWood", ExtraTreeItems.Sawdust.get(1));
		Food.registerOreDictionary();
		OreDictionary.registerOre("cropApple", Items.field_151034_e);
		OreDictionary.registerOre("cropHops", itemHops);
		OreDictionary.registerOre("seedWheat", Items.field_151014_N);
		OreDictionary.registerOre("seedWheat", ExtraTreeItems.GrainWheat.get(1));
		OreDictionary.registerOre("seedBarley", ExtraTreeItems.GrainBarley.get(1));
		OreDictionary.registerOre("seedCorn", ExtraTreeItems.GrainCorn.get(1));
		OreDictionary.registerOre("seedRye", ExtraTreeItems.GrainRye.get(1));
		OreDictionary.registerOre("seedRoasted", ExtraTreeItems.GrainRoasted.get(1));
		
		OreDictionary.registerOre("gearWood", ExtraTreeItems.ProvenGear.get(1));
	}

	@Override
	public void init() {
		Food.CRABAPPLE.addJuice(10, 150, 10);
		Food.ORANGE.addJuice(10, 400, 15);
		Food.KUMQUAT.addJuice(10, 300, 10);
		Food.LIME.addJuice(10, 300, 10);
		Food.WILD_CHERRY.addOil(20, 50, 5);
		Food.SOUR_CHERRY.addOil(20, 50, 3);
		Food.BLACK_CHERRY.addOil(20, 50, 5);
		Food.Blackthorn.addJuice(10, 50, 5);
		Food.CHERRY_PLUM.addJuice(10, 100, 60);
		Food.ALMOND.addOil(20, 80, 5);
		Food.APRICOT.addJuice(10, 150, 40);
		Food.GRAPEFRUIT.addJuice(10, 500, 15);
		Food.PEACH.addJuice(10, 150, 40);
		Food.SATSUMA.addJuice(10, 300, 10);
		Food.BUDDHA_HAND.addJuice(10, 400, 15);
		Food.CITRON.addJuice(10, 400, 15);
		Food.FINGER_LIME.addJuice(10, 300, 10);
		Food.KEY_LIME.addJuice(10, 300, 10);
		Food.MANDERIN.addJuice(10, 400, 10);
		Food.NECTARINE.addJuice(10, 150, 40);
		Food.POMELO.addJuice(10, 300, 10);
		Food.TANGERINE.addJuice(10, 300, 10);
		Food.PEAR.addJuice(10, 300, 20);
		Food.SAND_PEAR.addJuice(10, 200, 10);
		Food.HAZELNUT.addOil(20, 150, 5);
		Food.BUTTERNUT.addOil(20, 180, 5);
		Food.BEECHNUT.addOil(20, 100, 4);
		Food.PECAN.addOil(29, 50, 2);
		Food.BANANA.addJuice(10, 100, 30);
		Food.RED_BANANA.addJuice(10, 100, 30);
		Food.PLANTAIN.addJuice(10, 100, 40);
		Food.BRAZIL_NUT.addOil(20, 20, 2);
		Food.FIG.addOil(20, 50, 3);
		Food.ACORN.addOil(20, 50, 3);
		Food.ELDERBERRY.addJuice(10, 100, 5);
		Food.OLIVE.addOil(20, 50, 3);
		Food.GINGKO_NUT.addOil(20, 50, 5);
		Food.COFFEE.addOil(15, 20, 2);
		Food.OSANGE_ORANGE.addJuice(10, 300, 15);
		Food.CLOVE.addOil(10, 25, 2);
		Food.COCONUT.addOil(20, 300, 25);
		Food.CASHEW.addJuice(10, 150, 15);
		Food.AVACADO.addJuice(10, 300, 15);
		Food.NUTMEG.addOil(20, 50, 10);
		Food.ALLSPICE.addOil(20, 50, 10);
		Food.CHILLI.addJuice(10, 100, 10);
		Food.STAR_ANISE.addOil(20, 100, 10);
		Food.MANGO.addJuice(10, 400, 20);
		Food.STARFRUIT.addJuice(10, 300, 10);
		Food.CANDLENUT.addJuice(20, 50, 10);
	}

	@Override
	public void postInit() {
		ModuleItems items = ExtraTrees.items();
		
		MinecraftForge.addGrassSeed(new ItemStack(itemHops), 5);
		
		GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(items.itemDurableHammer, 1, 0), "wiw", " s ", " s ", 'w', Blocks.field_150343_Z, 'i', Items.field_151043_k, 's', Items.field_151055_y));
		GameRegistry.addRecipe(new ShapedOreRecipe(new ItemStack(items.itemHammer, 1, 0), "wiw", " s ", " s ", 'w', "plankWood", 'i', Items.field_151042_j, 's', Items.field_151055_y));
		GameRegistry.addRecipe(new ShapedOreRecipe(ExtraTreeItems.Yeast.get(8), " m ", "mbm", 'b', Items.field_151025_P, 'm', Blocks.field_150338_P));
		GameRegistry.addRecipe(new ShapedOreRecipe(ExtraTreeItems.LagerYeast.get(8), "mbm", " m ", 'b', Items.field_151025_P, 'm', Blocks.field_150338_P));
		GameRegistry.addRecipe(ExtraTreeItems.GrainWheat.get(5), " s ", "sss", " s ", 's', Items.field_151014_N);
		GameRegistry.addRecipe(new ShapedOreRecipe(ExtraTreeItems.GrainBarley.get(3), false, " s ", "s  ", " s ", 's', ExtraTreeItems.GrainWheat.get(1)));
		GameRegistry.addRecipe(new ShapedOreRecipe(ExtraTreeItems.GrainCorn.get(3), false, " s ", "  s", " s ", 's', ExtraTreeItems.GrainWheat.get(1)));
		GameRegistry.addRecipe(ExtraTreeItems.GrainRye.get(3), "   ", "s s", " s ", 's', ExtraTreeItems.GrainWheat.get(1));
		GameRegistry.addRecipe(ExtraTreeItems.ProvenGear.get(1), " s ", "s s", " s ", 's', Mods.Forestry.stack("oak_stick"));
		GameRegistry.addRecipe(ExtraTreeItems.GlassFitting.get(6), "s s", " i ", "s s", 'i', Items.field_151042_j, 's', Items.field_151055_y);
		GameRegistry.addSmelting(ExtraTreeItems.GrainWheat.get(1), ExtraTreeItems.GrainRoasted.get(1), 0.0f);
		GameRegistry.addSmelting(ExtraTreeItems.GrainRye.get(1), ExtraTreeItems.GrainRoasted.get(1), 0.0f);
		GameRegistry.addSmelting(ExtraTreeItems.GrainCorn.get(1), ExtraTreeItems.GrainRoasted.get(1), 0.0f);
		GameRegistry.addSmelting(ExtraTreeItems.GrainBarley.get(1), ExtraTreeItems.GrainRoasted.get(1), 0.0f);
		try {
			final Item minium = (Item) Class.forName("com.pahimar.ee3.lib.ItemIds").getField("minium_shard").get(null);
			GameRegistry.addRecipe(new ShapelessOreRecipe(Food.PAPAYIMAR.get(1), minium, "cropPapaya"));
		} catch (Exception ignored) {
		}
		ICarpenterManager carpenterManager = RecipeManagers.carpenterManager;
		IStillManager stillManager = RecipeManagers.stillManager;
		carpenterManager.addRecipe(100, Binnie.LIQUID.getFluidStack(ManagerLiquid.WATER, 2000), ItemStack.field_190927_a, new ItemStack(items.itemDictionary), "X#X", "YEY", "RDR", '#', Blocks.field_150410_aZ, 'X', Items.field_151043_k, 'Y', "ingotCopper", 'R', Items.field_151137_ax, 'D', Items.field_151045_i, 'E', Items.field_151166_bC);
		carpenterManager.addRecipe(100, Binnie.LIQUID.getFluidStack(ManagerLiquid.WATER, 2000), ItemStack.field_190927_a, new ItemStack(items.itemDictionaryLepi), "X#X", "YEY", "RDR", '#', Blocks.field_150410_aZ, 'X', Items.field_151043_k, 'Y', "ingotBronze", 'R', Items.field_151137_ax, 'D', Items.field_151045_i, 'E', Items.field_151166_bC);
		stillManager.addRecipe(25, ExtraTreeLiquid.Resin.get(5), ExtraTreeLiquid.Turpentine.get(3));
		carpenterManager.addRecipe(25, ExtraTreeLiquid.Turpentine.get(50), ItemStack.field_190927_a, items.itemMisc.getStack(ExtraTreeItems.WoodWax, 4), "x", 'x', Mods.Forestry.stack("beeswax"));
		FluidStack creosoteOil = Binnie.LIQUID.getFluidStack(ManagerLiquid.CREOSOTE, 50);
		if (creosoteOil != null) {
			carpenterManager.addRecipe(25, creosoteOil, ItemStack.field_190927_a, items.itemMisc.getStack(ExtraTreeItems.WoodWax, 1), "x", 'x', Mods.Forestry.stack("beeswax"));
		}

		FuelManager.bronzeEngineFuel.put(ExtraTreeLiquid.Sap.get(1).getFluid(), new EngineBronzeFuel(ExtraTreeLiquid.Sap.get(1).getFluid(), 20, 10000, 1));
		FuelManager.bronzeEngineFuel.put(ExtraTreeLiquid.Resin.get(1).getFluid(), new EngineBronzeFuel(ExtraTreeLiquid.Resin.get(1).getFluid(), 30, 10000, 1));
	}
}
