package binnie.core.craftgui.renderer;

import com.google.common.base.Preconditions;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.ForestryAPI;

import binnie.core.BinnieCore;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.geometry.TextJustification;

@SideOnly(Side.CLIENT)
public class RenderUtil {

	private RenderUtil() {

	}

	public static void drawItem(final Point pos, final ItemStack itemStack) {
		drawItem(pos, itemStack, false);
	}

	public static void drawItem(final Point pos, final ItemStack itemStack, final boolean rotating) {
		GlStateManager.func_179123_a();
		Preconditions.checkNotNull(itemStack);
		Minecraft minecraft = Minecraft.func_71410_x();
		net.minecraft.client.renderer.RenderHelper.func_74520_c();
		FontRenderer font = getFontRenderer(minecraft, itemStack);

		if (rotating) {
			GlStateManager.func_179094_E();
			final float phase = Minecraft.func_71386_F() / 20;
			/** {@link net.minecraft.client.renderer.RenderItem#setupGuiTransform(int, int, boolean)} It adds 100 to zLevel from
			 * {@link net.minecraft.client.renderer.RenderItem#renderItemAndEffectIntoGUI(net.minecraft.entity.EntityLivingBase, net.minecraft.item.ItemStack, int, int)}.
			 * So z=150
			 **/
			GlStateManager.func_179109_b(8, 8, 150);
			GlStateManager.func_179114_b(phase, 0, -0.866f, 0.5f);
			GlStateManager.func_179109_b(-8, -8, -150);
		}

		minecraft.func_175599_af().func_184391_a(null, itemStack, pos.x(), pos.y());
		if (rotating) {
			GlStateManager.func_179121_F();
		}
		minecraft.func_175599_af().func_180453_a(font, itemStack, pos.x(), pos.y(), null);

		net.minecraft.client.renderer.RenderHelper.func_74518_a();
		GlStateManager.func_179099_b();
	}

	private static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
		FontRenderer fontRenderer = ingredient.func_77973_b().getFontRenderer(ingredient);
		if (fontRenderer == null) {
			fontRenderer = minecraft.field_71466_p;
		}
		return fontRenderer;
	}

	public static void drawTexture(double xCoord, double yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, double zLevel) {
		double uMin = textureSprite.func_94209_e();
		double uMax = textureSprite.func_94212_f();
		double vMin = textureSprite.func_94206_g();
		double vMax = textureSprite.func_94210_h();
		uMax = uMax - maskRight / 16.0 * (uMax - uMin);
		vMax = vMax - maskTop / 16.0 * (vMax - vMin);

		Tessellator tessellator = Tessellator.func_178181_a();
		VertexBuffer vertexBuffer = tessellator.func_178180_c();
		vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
		vertexBuffer.func_181662_b(xCoord, yCoord + 16, zLevel).func_187315_a(uMin, vMax).func_181675_d();
		vertexBuffer.func_181662_b(xCoord + 16 - maskRight, yCoord + 16, zLevel).func_187315_a(uMax, vMax).func_181675_d();
		vertexBuffer.func_181662_b(xCoord + 16 - maskRight, yCoord + maskTop, zLevel).func_187315_a(uMax, vMin).func_181675_d();
		vertexBuffer.func_181662_b(xCoord, yCoord + maskTop, zLevel).func_187315_a(uMin, vMin).func_181675_d();
		tessellator.func_78381_a();
	}

	public static void setColour(final int hexColour) {
		int a = (hexColour & 0xFF000000) >> 24;
		final int r = (hexColour & 0xFF0000) >> 16;
		final int g = (hexColour & 0xFF00) >> 8;
		final int b = hexColour & 0xFF;
		if (a < 0) {
			a += 256;
		}
		if (a > 0 && a != 255) {
			GlStateManager.func_179131_c(r / 255.0f, g / 255.0f, b / 255.0f, a / 255.0f);
		} else {
			GlStateManager.func_179124_c(r / 255.0f, g / 255.0f, b / 255.0f);
		}
	}

	public static int getTextWidth(final String text) {
		FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
		return fontRendererObj.func_78256_a(text);
	}

	public static int getTextHeight() {
		FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
		return (fontRendererObj == null) ? 0 : fontRendererObj.field_78288_b;
	}

	public static void drawText(final Point pos, final String text, final int colour) {
		drawText(new Area(pos, new Point(500, 500)), TextJustification.TOP_LEFT, text, colour);
	}

	public static void drawText(final Area area, final TextJustification justification, final String text, final int colour) {
		final Point pos = area.pos();
		if (area.size().x() <= 0.0f) {
			return;
		}
		FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
		final List<String> wrappedStrings = fontRendererObj.func_78271_c(text, area.size().x());
		final float totalHeight = wrappedStrings.size() * getTextHeight();
		float posY = area.pos().y();
		if (area.size().y() > totalHeight) {
			posY += (area.size().y() - totalHeight) * justification.getYOffset();
		}
		for (final String string : wrappedStrings) {
			final float stringWidth = getTextWidth(string);
			float posX = area.size().x() - stringWidth;
			posX *= justification.getXOffset();
			GlStateManager.func_179097_i();
			fontRendererObj.func_78276_b(string, (int) (pos.x() + posX), (int) posY, colour);
			posY += getTextHeight();
		}
		GlStateManager.func_179124_c(1.0f, 1.0f, 1.0f);
	}

	public static void drawSolidRect(float left, float top, float right, float bottom, final int color) {
		GuiUtils.drawGradientRect(0, (int) left, (int) top, (int) right, (int) bottom, color, color);
	}

	public static void drawSolidRect(final Area area, final int colour) {
		drawSolidRect(area.pos().x(), area.pos().y(), area.pos().x() + area.size().x(), area.pos().y() + area.size().y(), 0xFF000000 | colour);
	}

	public static void drawSolidRectWithAlpha(final Area area, final int color) {
		drawSolidRect(area.pos().x(), area.pos().y(), area.pos().x() + area.size().x(), area.pos().y() + area.size().y(), color);
	}

	public static void drawGradientRect(final Area area, final int startColor, final int endColor) {
		GuiUtils.drawGradientRect(0, area.pos().x(), area.pos().y(), area.pos().x() + area.size().x(), area.pos().y() + area.size().y(), startColor, endColor);
	}

	public static void drawSprite(final Point pos, @Nullable final TextureAtlasSprite icon) {
		if (icon != null) {
			BinnieCore.getBinnieProxy().bindTexture(TextureMap.field_110575_b);
			drawTexture(pos.x(), pos.y(), icon, 0, 0, 0);
		}
	}

	public static void drawGuiSprite(final Point pos, @Nullable final TextureAtlasSprite icon) {
		if (icon != null) {
			BinnieCore.getBinnieProxy().bindTexture(ForestryAPI.textureManager.getGuiTextureMap());
			drawTexture(pos.x(), pos.y(), icon, 0, 0, 0);
		}
	}

	public static void drawFluid(Point pos, @Nullable FluidStack fluid) {
		GlStateManager.func_179147_l();
		GlStateManager.func_179141_d();

		Minecraft minecraft = Minecraft.func_71410_x();
		if (fluid != null) {
			Fluid fluid1 = fluid.getFluid();
			if (fluid1 != null) {
				TextureAtlasSprite fluidStillSprite = getStillFluidSprite(minecraft, fluid1);

				int fluidColor = fluid1.getColor(fluid);

				minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
				setColour(fluidColor);
				drawTexture(pos.x(), pos.y(), fluidStillSprite, 0, 0, 100);
			}
		}

		GlStateManager.func_179131_c(1, 1, 1, 1);
		GlStateManager.func_179118_c();
		GlStateManager.func_179084_k();
	}

	private static TextureAtlasSprite getStillFluidSprite(Minecraft minecraft, Fluid fluid) {
		TextureMap textureMapBlocks = minecraft.func_147117_R();
		ResourceLocation fluidStill = fluid.getStill();
		TextureAtlasSprite fluidStillSprite = null;
		if (fluidStill != null) {
			fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString());
		}
		if (fluidStillSprite == null) {
			fluidStillSprite = textureMapBlocks.func_174944_f();
		}
		return fluidStillSprite;
	}
}
