/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.models;

import binnie.core.block.IMultipassBlock;
import binnie.core.models.AABBModelBaker;
import forestry.api.core.IModelBaker;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockCached;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelMutlipass<B extends Block, K>
extends ModelBlockCached<B, K> {
    public ModelMutlipass(Class<B> blockClass) {
        super(blockClass);
    }

    protected K getInventoryKey(ItemStack stack) {
        return ((IMultipassBlock)Block.func_149634_a((Item)stack.func_77973_b())).getInventoryKey(stack);
    }

    protected K getWorldKey(IBlockState state) {
        return ((IMultipassBlock)state.func_177230_c()).getWorldKey(state);
    }

    protected IBakedModel bakeModel(IBlockState state, K key, B block) {
        if (key == null) {
            return null;
        }
        AABBModelBaker baker = new AABBModelBaker();
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
            BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
            baker.setModelBounds(state.func_185900_c(world, pos));
        } else {
            baker.setModelBounds(((IMultipassBlock)block).getItemBoundingBox());
        }
        this.bakeBlock(block, key, baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected void bakeBlock(B block, K key, IModelBaker baker, boolean inventory) {
        for (int pass = 0; pass < ((IMultipassBlock)block).getRenderPasses(); ++pass) {
            TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                sprites[facing.ordinal()] = ((IMultipassBlock)block).getSprite(key, facing, pass);
            }
            baker.addBlockModel(null, sprites, pass);
        }
        baker.setParticleSprite(((IMultipassBlock)block).getSprite(key, null, 0));
    }

    protected IBakedModel bakeModel(ItemStack stack, World world, K key) {
        if (key == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!this.blockClass.isInstance(block)) {
            return null;
        }
        Block bBlock = (Block)this.blockClass.cast(block);
        AABBModelBaker baker = new AABBModelBaker(((IMultipassBlock)bBlock).getItemBoundingBox());
        this.bakeBlock(bBlock, key, baker, true);
        this.itemModel = baker.bakeModel(true);
        return this.itemModel;
    }
}

