/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.craftgui.renderer.RenderUtil;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ControlSlotBase
extends Control
implements ITooltip {
    private ControlItemDisplay itemDisplay;

    public ControlSlotBase(IWidget parent, int x, int y) {
        this(parent, x, y, 18);
    }

    public ControlSlotBase(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
        this.addAttribute(Attribute.MouseOver);
        this.itemDisplay = new ControlItemDisplay(this, 1, 1, size - 2);
        this.addSelfEventHandler(new EventWidget.ChangeSize.Handler(){

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                ControlSlotBase.this.itemDisplay.setSize(ControlSlotBase.this.getSize().sub(new Point(2, 2)));
            }
        });
    }

    protected void setRotating() {
        this.itemDisplay.setRotating();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        int size = this.getSize().x();
        CraftGUI.render.texture((Object)CraftGUITexture.Slot, this.getArea());
        if (this.getTopParent().getMousedOverWidget() == this) {
            RenderUtil.drawGradientRect(new Area(new Point(1, 1), this.getArea().size().sub(new Point(2, 2))), -2130706433, -2130706433);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        this.itemDisplay.setItemStack(this.getItemStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip) {
        ItemStack stack = this.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        List list = stack.func_82840_a(((Window)this.getTopParent()).getPlayer(), false);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        tooltip.add(list);
    }

    public abstract ItemStack getItemStack();
}

