/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.analyser;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateDefinition;
import binnie.core.machines.power.IProcess;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.analyser.Analyser;
import net.minecraft.item.ItemStack;

public class AnalyserLogic
extends ComponentProcessSetCost
implements IProcess {
    private static final float DYE_PER_TICK = 0.002f;

    public AnalyserLogic(Machine machine) {
        super(machine, 9000, 300);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(6)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ANALYSER_NO_ITEM, 6);
        }
        boolean analysed = Analyser.isAnalysed(this.getUtil().getStack(6));
        if (analysed) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ANALYSER_ALREADY_ANALYSED, 6);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getMachine().getOwner() == null) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_OWNER, 6);
        }
        if (this.getUtil().getSlotCharge(13) == 0.0f) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ANALYSER_INSUFFICIENT_DYE, new int[]{13});
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        ItemStack itemStack = this.getUtil().getStack(6);
        itemStack = Analyser.analyse(itemStack, this.getMachine().getWorld(), this.getMachine().getOwner());
        this.getInventory().func_70299_a(6, itemStack);
    }

    @Override
    protected void onTickTask() {
        this.getUtil().useCharge(13, 0.002f);
    }
}

