package binnie.core.liquid;

import javax.annotation.Nullable;

import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;

import binnie.Binnie;
import binnie.extratrees.alcohol.AlcoholEffect;
import binnie.extratrees.alcohol.drink.DrinkManager;
import binnie.extratrees.alcohol.drink.IDrinkLiquid;

public class ItemFluidContainer extends ItemFood implements IItemModelRegister {
	private final FluidContainerType container;

	public ItemFluidContainer(FluidContainerType container) {
		super(0, false);
		this.container = container;
		container.setItem(this);
		this.field_77777_bU = container.getMaxStackSize();
		this.func_77627_a(true);
		this.func_77655_b("container" + container.getName());
		this.func_77637_a(CreativeTabs.field_78035_l);
		setRegistryName(container.getName());
	}

	@Override
	public String func_77653_i(final ItemStack itemstack) {
		FluidStack fluid = getContained(itemstack);
		if (fluid == null) {
			return "Empty " + container.getDisplayName();
		}
		return fluid.getFluid().getLocalizedName(fluid) + " " + this.container.getDisplayName();
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(final Item item, final CreativeTabs tab, final NonNullList<ItemStack> subItems) {
		super.func_150895_a(item, tab, subItems);
		for (final IFluidType liquid : Binnie.LIQUID.fluids.values()) {
			if (!liquid.canPlaceIn(this.container)) {
				continue;
			}
			if (!liquid.showInCreative(this.container)) {
				continue;
			}
			subItems.add(getContainer(liquid));
		}
	}

	@Nullable
	protected FluidStack getContained(ItemStack itemStack) {
		if (itemStack.func_190916_E() != 1) {
			itemStack = itemStack.func_77946_l();
			itemStack.func_190920_e(1);
		}
		IFluidHandler fluidHandler = new FluidHandlerItemBinnie(itemStack, container);
		return fluidHandler.drain(Integer.MAX_VALUE, false);
	}

	public ItemStack getContainer(final IFluidType liquid) {
		ItemStack itemStack = new ItemStack(this);
		IFluidHandler fluidHandler = new FluidHandlerItemBinnie(itemStack, container);
		if (fluidHandler.fill(new FluidStack(FluidRegistry.getFluid(liquid.getIdentifier()), Fluid.BUCKET_VOLUME), true) == Fluid.BUCKET_VOLUME) {
			return itemStack;
		}
		return container.getEmpty();
	}

	@Override
	public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
		if (entityLiving instanceof EntityPlayer) {
			EntityPlayer player = (EntityPlayer) entityLiving;
			player.func_71024_bL().func_151686_a(this, stack);
			world.func_184148_a((EntityPlayer) null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5F, world.field_73012_v.nextFloat() * 0.1F + 0.9F);
			func_77849_c(stack, world, player);
			return this.container.getEmpty();
		}
		return stack;
	}

	@Override
	protected void func_77849_c(final ItemStack itemStack, final World world, final EntityPlayer player) {
		if (!world.field_72995_K) {
			FluidStack fluid = getContained(itemStack);
			if (fluid != null) {
				final IDrinkLiquid liquid = DrinkManager.getLiquid(fluid);
				if (liquid != null) {
					AlcoholEffect.makeDrunk(player, liquid.getABV() * fluid.amount);
				}
			}
		}
	}

	@Override
	public EnumAction func_77661_b(final ItemStack stack) {
		if (isDrinkable(stack)) {
			return EnumAction.DRINK;
		}
		return EnumAction.NONE;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		ItemStack stack = playerIn.func_184586_b(handIn);
		if (this.isDrinkable(stack) && playerIn.func_71043_e(false)) {
			playerIn.func_184598_c(handIn);
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		} else {
			return super.func_77659_a(worldIn, playerIn, handIn);
		}
	}

	@Override
	public int func_77626_a(ItemStack stack) {
		if (isDrinkable(stack)) {
			return 32;
		} else {
			return 0;
		}
	}

	@Override
	public float func_150906_h(ItemStack stack) {
		return 0.0F;
	}

	@Override
	public int func_150905_g(ItemStack stack) {
		return 0;
	}

	private boolean isDrinkable(final ItemStack stack) {
		final FluidStack fluid = getContained(stack);
		if (fluid == null) {
			return false;
		}
		final IDrinkLiquid liquid = DrinkManager.getLiquid(fluid);
		return liquid != null && liquid.isConsumable();
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		FluidContainerMeshDefinition meshDefinition = new FluidContainerMeshDefinition();
		manager.registerItemModel(item, meshDefinition);
		ModelBakery.registerItemVariants(item, meshDefinition.location, meshDefinition.empty);
	}

	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
		return new FluidHandlerItemBinnie(stack, container);
	}

	@SideOnly(Side.CLIENT)
	private class FluidContainerMeshDefinition implements ItemMeshDefinition {

		final ModelResourceLocation location;
		final ModelResourceLocation empty;

		public FluidContainerMeshDefinition() {
			ResourceLocation location = getRegistryName();
			this.location = new ModelResourceLocation(location, "inventory");
			this.empty = new ModelResourceLocation(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "_empty"), "inventory");
		}

		@Override
		public ModelResourceLocation func_178113_a(ItemStack stack) {
			if (stack.func_77952_i() == 0) {
				return empty;
			}
			return location;
		}
	}
}
