/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.punnett;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.craftgui.renderer.RenderUtil;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.LinkedList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlPunnett
extends Control {
    static int boxWidth = 80;
    static int boxHeight = 28;

    protected ControlPunnett(IWidget parent, int x, int y) {
        super(parent, x, y, boxWidth * 3, boxWidth * 3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.drawSolidRect(new Area(0, boxHeight, boxWidth * 3, 1), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(boxWidth / 2, boxHeight * 2, Math.round((float)boxWidth * 2.5f), 1), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(boxWidth, 0, 1, boxHeight * 3), 0xAAAAAA);
        RenderUtil.drawSolidRect(new Area(boxWidth * 2, boxHeight / 2, 1, Math.round((float)boxHeight * 2.5f)), 0xAAAAAA);
    }

    public void setup(IChromosomeType chromosome, IIndividual ind1, IIndividual ind2, ISpeciesRoot root) {
        this.deleteAllChildren();
        if (chromosome == null || ind1 == null || ind2 == null || root == null) {
            return;
        }
        IAllele primary1 = ind1.getGenome().getActiveAllele(chromosome);
        IAllele primary2 = ind2.getGenome().getActiveAllele(chromosome);
        IAllele secondary1 = ind1.getGenome().getInactiveAllele(chromosome);
        IAllele secondary2 = ind2.getGenome().getInactiveAllele(chromosome);
        int x = 1;
        int y = 1;
        for (IAllele allele1 : new IAllele[]{primary1, secondary1}) {
            y = 1;
            for (IAllele allele2 : new IAllele[]{primary2, secondary2}) {
                LinkedList<IAllele> alleles = new LinkedList<IAllele>();
                if (allele1.isDominant() && !allele2.isDominant()) {
                    alleles.add(allele1);
                } else if (allele2.isDominant() && !allele1.isDominant()) {
                    alleles.add(allele2);
                } else {
                    alleles.add(allele1);
                    if (allele1 != allele2) {
                        alleles.add(allele2);
                    }
                }
                StringBuilder text = new StringBuilder();
                for (IAllele allele3 : alleles) {
                    text.append(allele3.getName()).append(": ").append(25.0f / (float)alleles.size()).append("%\n");
                }
                new ControlText(this, new Area(x * boxWidth, boxHeight * y, boxWidth, boxHeight), text.toString(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
                ++y;
            }
            ++x;
        }
        new ControlText(this, new Area(boxWidth, 0, boxWidth, boxHeight), "\n" + primary1.getName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(boxWidth * 2, 0, boxWidth, boxHeight), "\n" + secondary1.getName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(0, boxHeight, boxWidth, boxHeight), primary2.getName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
        new ControlText(this, new Area(0, boxHeight * 2, boxWidth, boxHeight), primary2.getName(), TextJustification.TOP_CENTER).setColor(0xAAAAAA);
    }
}

