/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.core;

import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.ITooltipHelp;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.Widget;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.Window;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Control
extends Widget
implements ITooltipHelp,
ITooltip {
    public int extraLevel = 0;
    List<String> helpStrings = new ArrayList<String>();
    List<String> tooltipStrings = new ArrayList<String>();

    public Control(IWidget parent, int x, int y, int w, int h) {
        super(parent);
        this.setPosition(new Point(x, y));
        this.setSize(new Point(w, h));
        this.initialise();
    }

    public Control(IWidget parent, Area area) {
        this(parent, area.xPos(), area.yPos(), area.width(), area.height());
    }

    protected void initialise() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
    }

    @Override
    @Nonnull
    public IWidget getParent() {
        return super.getParent();
    }

    public void addHelp(String string) {
        this.helpStrings.add(string);
    }

    public void addHelp(String[] strings) {
        for (String string : strings) {
            this.addHelp(string);
        }
    }

    public void addTooltip(String string) {
        this.addAttribute(Attribute.MouseOver);
        this.tooltipStrings.add(string);
    }

    public void addTooltip(String[] strings) {
        for (String string : strings) {
            this.addTooltip(string);
        }
    }

    @Override
    public int getLevel() {
        return this.extraLevel + super.getLevel();
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        tooltip.add(this.helpStrings);
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        tooltip.add(this.tooltipStrings);
    }

    public Window getWindow() {
        return (Window)this.getTopParent();
    }
}

