package binnie.botany.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentString;

import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

import forestry.api.genetics.AlleleManager;

import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.BinnieCore;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageNBT;
import binnie.core.util.I18N;

public enum PacketID implements IPacketID {
	FIELDKIT;

	@Override
	public void onMessage(MessageBinnie message, MessageContext context) {
		if (this == PacketID.FIELDKIT && context.side == Side.CLIENT) {
			MessageNBT packet = new MessageNBT(message);
			onUseFieldKit(packet.getTagCompound());
		}
	}

	public void onUseFieldKit(NBTTagCompound data) {
		EntityPlayer player = BinnieCore.getBinnieProxy().getPlayer();
		String info = "";
		if (data.func_82582_d()) {
			info += I18N.localise("botany.flowers.species.not.discover");
		} else {
			IAlleleFlowerSpecies primary = (IAlleleFlowerSpecies) AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species"));
			IAlleleFlowerSpecies secondary = (IAlleleFlowerSpecies) AlleleManager.alleleRegistry.getAllele(data.func_74779_i("Species2"));
			float age = data.func_74760_g("Age");
			EnumFlowerColor color1 = EnumFlowerColor.get(data.func_74765_d("Colour"));
			EnumFlowerColor color2 = EnumFlowerColor.get(data.func_74765_d("Colour2"));
			if (primary == null || secondary == null) {
				return;
			}

			info += I18N.localise("botany.flowers.fielkit.a");
			if (age == 0.0f) {
				info += "";
			} else if (age < 0.25f) {
				info += " " + I18N.localise("botany.flowers.fielkit.young");
			} else if (age < 0.75f) {
				info += " " + I18N.localise("botany.flowers.fielkit.mature");
			} else {
				info += " " + I18N.localise("botany.flowers.fielkit.old");
			}

			if (color1 == color2) {
				info = info + " " + color1.func_176610_l();
			} else {
				info = info + " " + color1.func_176610_l() + " & " + color2.func_176610_l();
			}

			if (primary == secondary) {
				info = info + " " + primary.getName();
			} else {
				info = info + " " + primary.getName() + "-" + secondary.getName() + " " + I18N.localise("botany.flowers.species.hybrid");
			}

			if (age == 0.0f) {
				info += " " + I18N.localise("botany.flowers.species.germling");
			}
			if (data.func_74767_n("Wilting")) {
				info += ". " + I18N.localise("botany.flowers.species.wilting");
			}
		}
		player.func_146105_b(new TextComponentString(info), false);
	}
}
