/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.fruitpress;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.fruitpress.FruitPressLogic;
import binnie.extratrees.machines.fruitpress.SlotValidatorSqueezable;
import net.minecraft.tileentity.TileEntity;

public class FruitPressMachine
extends ExtraTreeMachine.PackageExtraTreeMachine
implements IMachineInformation {
    public static final int SLOT_FRUIT = 0;
    public static final int SLOT_CURRENT = 1;
    public static final int TANK_OUTPUT = 0;
    public static final int TANK_OUTPUT_CAPACITY = 5000;

    public FruitPressMachine() {
        super("press", ExtraTreeTexture.Press, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Press);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot input = inventory.addSlot(0, "input");
        input.setValidator(new SlotValidatorSqueezable());
        input.forbidExtraction();
        InventorySlot process = inventory.addSlot(1, "process");
        process.setValidator(new SlotValidatorSqueezable());
        process.forbidInteraction();
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        tanks.addTank(0, "output", 5000);
        new ComponentPowerReceptor(machine);
        new ComponentInventoryTransfer(machine).addRestock(new int[]{0}, 1, 1);
        new FruitPressLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

