/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.scroll;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.scroll.ControlScroll;
import binnie.core.craftgui.controls.scroll.IControlScrollable;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import javax.annotation.Nullable;

public class ControlScrollableContent<T extends IWidget>
extends Control
implements IControlScrollable {
    @Nullable
    protected T controlChild;
    protected int scrollBarSize;
    float percentageIndex = 0.0f;

    public ControlScrollableContent(IWidget parent, int x, int y, int w, int h, int scrollBarSize) {
        super(parent, x, y, w, h);
        if (scrollBarSize != 0) {
            new ControlScroll(this, this.getSize().x() - scrollBarSize, 0, scrollBarSize, this.getSize().y(), this);
        }
        this.addEventHandler(new EventMouse.Wheel.Handler(){

            @Override
            public void onEvent(EventMouse.Wheel event) {
                if (ControlScrollableContent.this.getRelativeMousePosition().x() > 0 && ControlScrollableContent.this.getRelativeMousePosition().y() > 0 && ControlScrollableContent.this.getRelativeMousePosition().x() < ControlScrollableContent.this.getSize().x() && ControlScrollableContent.this.getRelativeMousePosition().y() < ControlScrollableContent.this.getSize().y()) {
                    if (ControlScrollableContent.this.getMovementRange() == 0.0f) {
                        return;
                    }
                    float percentageMove = 0.8f / ControlScrollableContent.this.getMovementRange();
                    ControlScrollableContent.this.movePercentage(percentageMove * (float)(-event.getDWheel()));
                }
            }
        });
        this.scrollBarSize = scrollBarSize;
    }

    public void setScrollableContent(@Nullable T child) {
        this.controlChild = child;
        if (child == null) {
            return;
        }
        child.setCroppedZone(this, new Area(1, 1, this.getSize().x() - 2 - this.scrollBarSize, this.getSize().y() - 2));
        child.addSelfEventHandler(new EventWidget.ChangeSize.Handler((IWidget)child){
            final /* synthetic */ IWidget val$child;
            {
                this.val$child = iWidget;
            }

            @Override
            public void onEvent(EventWidget.ChangeSize event) {
                this.val$child.setOffset(new Point(0, Math.round(-ControlScrollableContent.this.percentageIndex * ControlScrollableContent.this.getMovementRange())));
                if (ControlScrollableContent.this.getMovementRange() == 0.0f) {
                    ControlScrollableContent.this.percentageIndex = 0.0f;
                }
            }
        });
    }

    @Nullable
    public T getContent() {
        return this.controlChild;
    }

    @Override
    public float getPercentageShown() {
        if (this.controlChild == null || this.controlChild.getSize().y() == 0) {
            return 1.0f;
        }
        float shown = (float)this.getSize().y() / (float)this.controlChild.getSize().y();
        return Math.min(shown, 1.0f);
    }

    @Override
    public float getPercentageIndex() {
        return this.percentageIndex;
    }

    @Override
    public void setPercentageIndex(float index) {
        this.movePercentage(index - this.percentageIndex);
    }

    @Override
    public void movePercentage(float percentage) {
        if (this.controlChild == null) {
            return;
        }
        this.percentageIndex += percentage;
        if (this.percentageIndex > 1.0f) {
            this.percentageIndex = 1.0f;
        } else if (this.percentageIndex < 0.0f) {
            this.percentageIndex = 0.0f;
        }
        if (this.getMovementRange() == 0.0f) {
            this.percentageIndex = 0.0f;
        }
        this.controlChild.setOffset(new Point(0, Math.round(-this.percentageIndex * this.getMovementRange())));
    }

    @Override
    public float getMovementRange() {
        if (this.controlChild == null) {
            return 0.0f;
        }
        float range = this.controlChild.getSize().y() - this.getSize().y();
        return Math.max(range, 0.0f);
    }

    @Override
    public void onUpdateClient() {
        this.setPercentageIndex(this.getPercentageIndex());
    }

    public void ensureVisible(float minY, float maxY, float totalY) {
        float percentageIndex;
        minY /= totalY;
        float shownPercentage = this.getPercentageShown();
        float minPercent = (1.0f - shownPercentage) * (percentageIndex = this.getPercentageIndex());
        float maxPercent = minPercent + shownPercentage;
        if ((maxY /= totalY) > maxPercent) {
            this.setPercentageIndex((maxY - shownPercentage) / (1.0f - shownPercentage));
        }
        if (minY < minPercent) {
            this.setPercentageIndex(minY / (1.0f - shownPercentage));
        }
    }
}

