package binnie.genetics.machine.isolator;

import java.util.Random;

import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;

public class IsolaterFX extends MachineComponent implements IRender.RandomDisplayTick, IRender.DisplayTick {
	public IsolaterFX(final IMachine machine) {
		super(machine);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void onRandomDisplayTick(World world, BlockPos pos, Random rand) {
		if (!this.getUtil().getProcess().isInProgress()) {
			return;
		}
		final Particle particle = new IsolaterParticleRandomTick(world, pos, rand);
		BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a(particle);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void onDisplayTick(World world, BlockPos pos, Random rand) {
		final int tick = (int) (world.func_82737_E() % 6L);
		if ((tick == 0 || tick == 5) && this.getUtil().getProcess().isInProgress()) {
			final Particle particle = new IsolaterParticle(world, pos);
			BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a(particle);
		}
	}

	@SideOnly(Side.CLIENT)
	private static class IsolaterParticleRandomTick extends Particle {
		double axisX;
		double axisZ;
		double angle;

		public IsolaterParticleRandomTick(World world, BlockPos pos, Random rand) {
			super(world, pos.func_177958_n() + 0.4 + 0.2 * rand.nextDouble(), pos.func_177956_o() + 1.6, pos.func_177952_p() + 0.4 + rand.nextDouble() * 0.2, 0.0, 0.0, 0.0);
			axisX = 0.0;
			axisZ = 0.0;
			angle = 0.0;
			this.field_187129_i = 0.0;
			this.field_187131_k = 0.0;
			this.field_187130_j = -0.012;
			this.field_70547_e = 100;
			this.field_70545_g = 0.0f;
			this.field_190017_n = true;
			this.func_70538_b(0.8f, 0.4f, 0.0f);
		}

		@Override
		public void func_189213_a() {
			super.func_189213_a();
			this.angle += 0.06;
			this.func_82338_g((float) Math.sin(3.14 * this.field_70546_d / this.field_70547_e));
		}

		@Override
		public int func_70537_b() {
			return 0;
		}
	}

	@SideOnly(Side.CLIENT)
	private static class IsolaterParticle extends Particle {
		double axisX;
		double axisZ;
		double angle;

		public IsolaterParticle(World world, BlockPos pos) {
			super(world, pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
			axisX = this.field_187126_f;
			axisZ = this.field_187128_h;
			angle = 0.7 + (int) (this.field_187122_b.func_82737_E() % 2L) * 3.1415;
			this.axisX = 0.0;
			this.axisZ = 0.0;
			this.angle = 0.0;
			this.field_187129_i = 0.0;
			this.field_187131_k = 0.0;
			this.field_187130_j = 0.012;
			this.field_70547_e = 100;
			this.field_70545_g = 0.0f;
			this.field_190017_n = true;
			this.func_70538_b(0.8f, 0.0f, 1.0f);
		}

		@Override
		public void func_189213_a() {
			super.func_189213_a();
			this.angle += 0.06;
			this.func_187109_b(this.axisX + 0.26 * Math.sin(this.angle), this.field_187127_g, this.axisZ + 0.26 * Math.cos(this.angle));
			this.func_82338_g((float) Math.cos(1.57 * this.field_70546_d / this.field_70547_e));
		}

		@Override
		public int func_70537_b() {
			return 0;
		}
	}
}
