/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IGermlingModelProvider;
import forestry.api.core.IModelManager;
import java.awt.Color;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumSaplingType {
    Default,
    Jungle,
    Conifer,
    Fruit,
    Poplar,
    Palm,
    Shrub;


    public IGermlingModelProvider getGermlingModelProvider(Color leaf, Color wood) {
        return new DefaultGermlingModelProvider(this, leaf, wood);
    }

    private class DefaultGermlingModelProvider
    implements IGermlingModelProvider {
        private ModelResourceLocation germlingModel;
        private ModelResourceLocation pollenModel;
        private EnumSaplingType saplingType;
        private Color leaf;
        private Color wood;

        public DefaultGermlingModelProvider(EnumSaplingType saplingType, Color leaf, Color wood) {
            this.saplingType = saplingType;
            this.wood = wood;
            this.leaf = leaf;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels(Item item, IModelManager manager, EnumGermlingType type) {
            if (type == EnumGermlingType.SAPLING) {
                this.germlingModel = manager.getModelLocation("extratrees", "saplings/tree_" + EnumSaplingType.this.name());
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("extratrees", "saplings/tree_" + EnumSaplingType.this.name())});
            }
            if (type == EnumGermlingType.POLLEN) {
                this.pollenModel = manager.getModelLocation("pollen");
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("forestry:pollen")});
            }
        }

        public ModelResourceLocation getModel(EnumGermlingType type) {
            if (type == EnumGermlingType.SAPLING) {
                return this.germlingModel;
            }
            if (type == EnumGermlingType.POLLEN) {
                return this.pollenModel;
            }
            return this.germlingModel;
        }

        public int getSpriteColor(EnumGermlingType type, int renderPass) {
            return type == EnumGermlingType.SAPLING && renderPass == 0 ? this.wood.getRGB() : this.leaf.getRGB();
        }
    }
}

