/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.bee;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.CraftGUIUtil;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.kitchen.craftgui.ControlFluidDisplay;
import binnie.genetics.gui.AnalystPageProduce;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystPageProducts
extends AnalystPageProduce {
    public AnalystPageProducts(IWidget parent, Area area, IBee ind) {
        super(parent, area);
        this.setColor(0xCC3300);
        IBeeGenome genome = ind.getGenome();
        float speed = genome.getSpeed();
        float modeSpeed = Binnie.GENETICS.getBeeRoot().getBeekeepingMode(BinnieCore.getBinnieProxy().getWorld()).getBeeModifier().getProductionModifier(genome, 1.0f);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextCentered((IWidget)this, y += 12, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.produces.rate") + ": " + Binnie.GENETICS.beeBreedingSystem.getAlleleName((IChromosomeType)EnumBeeChromosome.SPEED, ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.SPEED))).setColor(this.getColor());
        y += 20;
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        UniqueItemStackSet productList = new UniqueItemStackSet();
        UniqueItemStackSet specialtyList = new UniqueItemStackSet();
        Map products = new HashMap();
        products.putAll(genome.getPrimary().getProductChances());
        products.putAll(genome.getSecondary().getProductChances());
        if (!products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.natural")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                if (!productList.add(entry.getKey())) continue;
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        if (!(products = genome.getPrimary().getSpecialtyChances()).isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.specialty")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.products.refined")).setColor(this.getColor());
        y += 12;
        UniqueItemStackSet level2Products = new UniqueItemStackSet();
        for (Object stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts((ItemStack)stack));
        }
        refinedProducts.addAll(level2Products);
        level2Products = new UniqueItemStackSet();
        for (Object stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts((ItemStack)stack));
        }
        refinedProducts.addAll(level2Products);
        ArrayList<FluidStack> allFluids = new ArrayList<FluidStack>();
        for (ItemStack stack2 : refinedProducts) {
            for (FluidStack addition : this.getAllFluids(stack2)) {
                boolean alreadyIn = false;
                for (FluidStack existing : allFluids) {
                    if (!existing.isFluidEqual(addition)) continue;
                    alreadyIn = true;
                }
                if (alreadyIn) continue;
                allFluids.add(addition);
            }
        }
        int maxBiomePerLine = (int)(((float)this.width() + 2.0f - 16.0f) / 18.0f);
        int biomeListX = (this.width() - (Math.min(maxBiomePerLine, allFluids.size() + refinedProducts.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : refinedProducts) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ControlItemDisplay display = new ControlItemDisplay(this, biomeListX + dx, y + dy);
            display.setItemStack(soilStack);
            display.setTooltip();
            dx += 18;
        }
        for (FluidStack soilStack2 : allFluids) {
            ItemStack container;
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            if ((container = AnalystPageProducts.getContainer(soilStack2)) == null) {
                ControlFluidDisplay display2 = new ControlFluidDisplay(this, biomeListX + dx, y + dy);
                display2.setFluidStack(soilStack2);
                display2.setTooltip();
            } else {
                ControlItemDisplay display3 = new ControlItemDisplay(this, biomeListX + dx, y + dy);
                display3.setItemStack(container);
                display3.setTooltip();
            }
            dx += 18;
        }
        this.setSize(new Point(this.width(), y + dy + 18 + 8));
    }

    @Nullable
    public static ItemStack getContainer(FluidStack fluidStack) {
        ItemStack[] containers;
        for (ItemStack container : containers = new ItemStack[]{new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151133_ar)}) {
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
            if (fluidHandler == null || fluidHandler.fill(fluidStack, true) <= 0) continue;
            return fluidHandler.getContainer();
        }
        return null;
    }

    private void createProductEntry(final ItemStack key, Float value, int y, float speed) {
        ControlItemDisplay item = new ControlItemDisplay(this, 16, y){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void getTooltip(Tooltip tooltip) {
                NonNullList<ItemStack> liquids;
                super.getTooltip(tooltip);
                Collection<ItemStack> products = AnalystPageProducts.this.getCentrifuge(key);
                if (!products.isEmpty()) {
                    tooltip.add(I18N.localise("genetics.gui.analyst.products.centrifuges") + ": ");
                    for (ItemStack prod : products) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        prod.func_77955_b(nbt);
                        tooltip.add(prod, prod.func_82833_r());
                    }
                }
                if (!(liquids = AnalystPageProducts.this.getSqueezer(key)).isEmpty()) {
                    tooltip.add(I18N.localise("genetics.gui.analyst.products.squeezes") + ": ");
                    for (ItemStack prod2 : liquids) {
                        NBTTagCompound nbt2 = new NBTTagCompound();
                        prod2.func_77955_b(nbt2);
                        tooltip.add(prod2, prod2.func_82833_r());
                    }
                }
            }
        };
        item.setTooltip();
        ControlTextCentered textWidget = new ControlTextCentered((IWidget)this, y + 4, "");
        textWidget.setColor(this.getColor());
        CraftGUIUtil.moveWidget(textWidget, new Point(12, 0));
        item.setItemStack(key);
        int time = (int)(55000.0 / (double)(speed * value.floatValue()));
        textWidget.setValue(I18N.localise("genetics.gui.analyst.products.every") + " " + this.getTimeString(time));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.produces.title");
    }
}

