/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic.brick;

import binnie.botany.CreativeTabBotany;
import binnie.botany.ceramic.TileCeramic;
import binnie.botany.ceramic.brick.CeramicBrickPair;
import binnie.botany.ceramic.brick.CeramicBrickType;
import binnie.botany.ceramic.brick.TileCeramicBrick;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.BinnieCore;
import binnie.core.block.IMultipassBlock;
import binnie.core.models.DefaultStateMapper;
import binnie.core.models.ModelManager;
import binnie.core.models.ModelMutlipass;
import binnie.core.util.TileUtil;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.ITextureManager;
import forestry.core.blocks.IColoredBlock;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.BlockModelEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCeramicBrick
extends Block
implements IMultipassBlock<CeramicBrickPair>,
IColoredBlock,
ISpriteRegister,
IStateMapperRegister,
IItemModelRegister {
    private static final PropertyEnum<CeramicBrickType> TYPE = PropertyEnum.func_177709_a((String)"type", CeramicBrickType.class);

    public BlockCeramicBrick() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.setRegistryName("ceramicBrick");
        this.func_149647_a(CreativeTabBotany.instance);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, @Nullable EntityPlayer player, boolean willHarvest) {
        boolean hasBeenBroken;
        List<Object> drops = new ArrayList();
        TileCeramic ceramic = TileUtil.getTile((IBlockAccess)world, pos, TileCeramic.class);
        if (ceramic != null) {
            drops = Collections.singletonList(ceramic.getStack());
        }
        if ((hasBeenBroken = world.func_175698_g(pos)) && BinnieCore.getBinnieProxy().isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack itemStack : drops) {
                BlockCeramicBrick.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
            }
        }
        return hasBeenBroken;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCeramicBrick();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (EnumFlowerColor enumFlowerColor : EnumFlowerColor.values()) {
            itemList.add((Object)new CeramicBrickPair(enumFlowerColor, enumFlowerColor, CeramicBrickType.TILE).getStack(1));
        }
        for (Enum enum_ : CeramicBrickType.VALUES) {
            if (!((CeramicBrickType)enum_).canDouble()) continue;
            itemList.add((Object)new CeramicBrickPair(EnumFlowerColor.Brown, EnumFlowerColor.Gold, (CeramicBrickType)enum_).getStack(1));
        }
        itemList.add((Object)new CeramicBrickPair(EnumFlowerColor.Gold, EnumFlowerColor.Gold, CeramicBrickType.SPLIT).getStack(1));
        itemList.add((Object)new CeramicBrickPair(EnumFlowerColor.Brown, EnumFlowerColor.Brown, CeramicBrickType.CHEQUERED).getStack(1));
        itemList.add((Object)new CeramicBrickPair(EnumFlowerColor.Gold, EnumFlowerColor.Brown, CeramicBrickType.LARGE_BRICK).getStack(1));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ResourceLocation resourceLocation = new ResourceLocation("botany", "ceramicBrick");
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new DefaultStateMapper(resourceLocation));
        ModelManager.registerCustomBlockModel(new BlockModelEntry(new ModelResourceLocation(resourceLocation, "normal"), new ModelResourceLocation(resourceLocation, "inventory"), new ModelMutlipass(BlockCeramicBrick.class), (Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, (ItemMeshDefinition)new CeramicBrickMeshDefinition());
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TYPE}, new IUnlistedProperty[]{UnlistedBlockPos.POS, UnlistedBlockAccess.BLOCKACCESS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)CeramicBrickType.VALUES[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((CeramicBrickType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty((IUnlistedProperty)UnlistedBlockPos.POS, (Object)pos).withProperty((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS, (Object)world);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)CeramicBrickType.get(meta >> 16 & 0xFF)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCeramicBrick ceramic = TileUtil.getTile((IBlockAccess)worldIn, pos, TileCeramicBrick.class);
        if (ceramic != null) {
            int damage = stack.func_77952_i();
            ceramic.setColors(EnumFlowerColor.get(damage & 0xFF), EnumFlowerColor.get(damage >> 8 & 0xFF));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileCeramicBrick ceramic = TileUtil.getTile((IBlockAccess)world, pos, TileCeramicBrick.class);
        if (ceramic != null) {
            return ceramic.pair().getStack(0);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        TileCeramicBrick ceramic;
        if (world != null && pos != null && (ceramic = TileUtil.getTile(world, pos, TileCeramicBrick.class)) != null) {
            if (tintIndex == 1) {
                return ceramic.getColorFirst().getFlowerColorAllele().getColor(false);
            }
            if (tintIndex == 2) {
                return ceramic.getColorSecond().getFlowerColorAllele().getColor(false);
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses() {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CeramicBrickPair getInventoryKey(ItemStack stack) {
        return new CeramicBrickPair(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CeramicBrickPair getWorldKey(IBlockState state) {
        BlockPos pos;
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)extendedState.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        TileCeramicBrick ceramic = TileUtil.getTile(world, pos = (BlockPos)extendedState.getValue((IUnlistedProperty)UnlistedBlockPos.POS), TileCeramicBrick.class);
        if (ceramic != null) {
            return ceramic.pair();
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(CeramicBrickPair type, @Nullable EnumFacing facing, int pass) {
        return type.getSprite(pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(ITextureManager manager) {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        for (CeramicBrickType type : CeramicBrickType.VALUES) {
            type.sprites = new TextureAtlasSprite[3];
            for (int i = 0; i < 3; ++i) {
                type.sprites[i] = textureMap.func_174942_a(new ResourceLocation("botany:blocks/ceramic." + type.id + "." + i));
            }
        }
    }

    private class CeramicBrickMeshDefinition
    implements ItemMeshDefinition {
        private CeramicBrickMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return new ModelResourceLocation("botany:ceramicBrick", "inventory");
        }
    }
}

