package binnie.extratrees.block.decor;

import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import binnie.extratrees.block.IPlankType;
import binnie.extratrees.block.WoodManager;

public class MultiFenceRecipeEmbedded implements IRecipe {
	private ItemStack cached = ItemStack.field_190927_a;

	@Override
	public boolean func_77569_a(final InventoryCrafting inv, final World world) {
		for (int row = 0; row < 3; ++row) {
			ItemStack a = inv.func_70301_a(row * 3);
			ItemStack b = inv.func_70301_a(row * 3 + 1);
			ItemStack c = inv.func_70301_a(row * 3 + 2);
			if (!a.func_190926_b() && !b.func_190926_b() && !c.func_190926_b()) {
				FenceType type = WoodManager.getFenceType(a);
				FenceType typeSecond = WoodManager.getFenceType(c);
				if (type != null && typeSecond != null && type.equals(typeSecond)) {
					FenceDescription fenceDescription = WoodManager.getFenceDescription(a);
					if (fenceDescription != null) {
						IPlankType descPlankType = fenceDescription.getPlankType();
						IPlankType plankType = WoodManager.getPlankType(b);
						if (descPlankType == plankType) {
							this.cached = WoodManager.getFence(descPlankType, fenceDescription.getSecondaryPlankType(), new FenceType(type.size, type.solid, true), 2);
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	@Override
	public ItemStack func_77572_b(final InventoryCrafting inv) {
		return this.func_77571_b();
	}

	@Override
	public int func_77570_a() {
		return 3;
	}

	@Override
	public ItemStack func_77571_b() {
		return (this.cached.func_190926_b()) ? new ItemStack(Blocks.field_180407_aO) : this.cached;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}
}
