package binnie.core.craftgui.controls;

import net.minecraft.client.gui.GuiTextField;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventKey;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventTextEdit;
import binnie.core.craftgui.events.EventWidget;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;

@SideOnly(Side.CLIENT)
public class ControlTextEdit extends Control implements IControlValue<String> {
	private GuiTextField field;
	private String cachedValue;

	public ControlTextEdit(final IWidget parent, final int x, final int y, final int width, final int height) {
		super(parent, x, y, width, height);
		this.cachedValue = "";
		this.field = new GuiTextField(0, this.getWindow().getGui().getFontRenderer(), 0, 0, 10, 10);
		this.addAttribute(Attribute.CanFocus);
		this.addAttribute(Attribute.MouseOver);
		this.field.func_146185_a(false);
		this.addEventHandler(new EventKey.Down.Handler() {
			@Override
			public void onEvent(final EventKey.Down event) {
				ControlTextEdit.this.field.func_146201_a(event.getCharacter(), event.getKey());
				final String text = ControlTextEdit.this.getValue();
				if (!text.equals(ControlTextEdit.this.cachedValue)) {
					ControlTextEdit.this.cachedValue = text;
					ControlTextEdit.this.callEvent(new EventTextEdit(ControlTextEdit.this, ControlTextEdit.this.cachedValue));
					ControlTextEdit.this.onTextEdit(ControlTextEdit.this.cachedValue);
				}
			}
		}.setOrigin(EventHandler.Origin.Self, this));
		this.addEventHandler(new EventMouse.Down.Handler() {
			@Override
			public void onEvent(final EventMouse.Down event) {
				ControlTextEdit.this.field.func_146192_a(ControlTextEdit.this.getRelativeMousePosition().x(), ControlTextEdit.this.getRelativeMousePosition().y(), event.getButton());
			}
		}.setOrigin(EventHandler.Origin.Self, this));
		this.addEventHandler(new EventWidget.GainFocus.Handler() {
			@Override
			public void onEvent(final EventWidget.GainFocus event) {
				ControlTextEdit.this.field.func_146195_b(true);
			}
		}.setOrigin(EventHandler.Origin.Self, this));
		this.addEventHandler(new EventWidget.LoseFocus.Handler() {
			@Override
			public void onEvent(final EventWidget.LoseFocus event) {
				ControlTextEdit.this.field.func_146195_b(false);
			}
		}.setOrigin(EventHandler.Origin.Self, this));
	}

	@Override
	public String getValue() {
		return (this.field.func_146179_b() == null) ? "" : this.field.func_146179_b();
	}

	@Override
	public void setValue(final String value) {
		if (!this.getValue().equals(value)) {
			this.field.func_146180_a(value);
			this.field.func_146190_e(0);
		}
	}

	@Override
	public void onUpdateClient() {
	}

	protected void onTextEdit(final String value) {
	}

	@Override
	public void onRenderBackground(int guiWidth, int guiHeight) {
		CraftGUI.render.texture(CraftGUITexture.Slot, this.getArea());
		this.renderTextField();
	}

	protected void renderTextField() {
		this.field.field_146218_h = this.width();
		this.field.field_146219_i = this.height();
		this.field.field_146209_f = (int) ((this.height() - 8.0f) / 2.0f);
		this.field.field_146210_g = (int) ((this.height() - 8.0f) / 2.0f);
		this.field.func_146194_f();
	}
}
