/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.craftgui;

import binnie.Binnie;
import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.renderer.RenderUtil;
import binnie.core.genetics.BreedingSystem;
import binnie.genetics.api.IGene;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlGene
extends Control
implements IControlValue<IGene>,
ITooltip {
    private IGene gene;

    protected ControlGene(IWidget parent, int x, int y, IGene gene) {
        super(parent, x, y, 16, 16);
        this.gene = gene;
        this.addAttribute(Attribute.MouseOver);
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            public void onEvent(EventMouse.Down event) {
                if (ControlGene.this.canFill(((Window)Window.get(ControlGene.this.getWidget())).getHeldItemStack())) {
                    NBTTagCompound action = new NBTTagCompound();
                    NBTTagCompound geneNBT = new NBTTagCompound();
                    ControlGene.this.getValue().writeToNBT(geneNBT);
                    action.func_74782_a("gene", (NBTBase)geneNBT);
                    ((Window)Window.get(ControlGene.this.getWidget())).sendClientAction("gene-select", action);
                }
            }
        });
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        BreedingSystem system = Binnie.GENETICS.getSystem(this.gene.getSpeciesRoot());
        String cName = system.getChromosomeName(this.gene.getChromosome());
        tooltip.add(cName + ": " + this.gene.getName());
        if (this.isMouseOver() && this.canFill(((Window)Window.get(this)).getHeldItemStack())) {
            tooltip.add("Left click to assign gene");
            IGene existingGene = Engineering.getGene(((Window)Window.get(this)).getHeldItemStack(), this.gene.getChromosome().ordinal());
            if (existingGene == null) {
                return;
            }
            String dName = system.getChromosomeName(this.gene.getChromosome());
            tooltip.add("Will replace " + dName + ": " + existingGene.getName());
        }
    }

    private boolean canFill(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_190916_E() == 1 && Engineering.isGeneAcceptor(stack) && Engineering.canAcceptGene(stack, this.getValue());
    }

    @Override
    public IGene getValue() {
        return this.gene;
    }

    @Override
    public void setValue(IGene value) {
        this.gene = value;
    }

    @Override
    public void onRenderForeground(int guiWidth, int guiHeight) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (this.isMouseOver() && this.canFill(((Window)Window.get(this)).getHeldItemStack())) {
            RenderUtil.drawSolidRect(this.getArea(), -1);
            RenderUtil.drawSolidRect(this.getArea().inset(1), -12303292);
        }
        RenderUtil.setColour(-1);
        RenderUtil.drawSprite(Point.ZERO, GeneticsTexture.dnaIcon.getSprite());
    }
}

