/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.bee.database;

import binnie.Binnie;
import binnie.core.craftgui.Attribute;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlBiomes
extends Control
implements ITooltip {
    List<Integer> tolerated = new ArrayList<Integer>();

    public ControlBiomes(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width * 16, height * 16);
        this.addAttribute(Attribute.MouseOver);
    }

    @Override
    public void getTooltip(Tooltip list) {
        int y;
        if (this.tolerated.isEmpty()) {
            return;
        }
        int x = (int)((float)this.getRelativeMousePosition().x() / 16.0f);
        int i = x + (y = (int)((float)this.getRelativeMousePosition().y() / 16.0f)) * 8;
        if (i >= this.tolerated.size()) {
            return;
        }
        Biome biome = Biome.func_150568_d((int)this.tolerated.get(i));
        if (biome != null) {
            list.add(biome.func_185359_l());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        for (int i = 0; i < this.tolerated.size(); ++i) {
            int x = i % 8 * 16;
            int y = i / 8 * 16;
            if (Biome.func_150568_d((int)i) != null) {
                // empty if block
            }
            CraftGUI.render.texture((Object)CraftGUITexture.Button, new Area(x, y, 16, 16));
        }
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        this.tolerated.clear();
        IBeeGenome genome = Binnie.GENETICS.getBeeRoot().templateAsGenome(Binnie.GENETICS.getBeeRoot().getTemplate((IAlleleSpecies)species));
        IBee bee = Binnie.GENETICS.getBeeRoot().getBee(genome);
    }
}

