/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.botany.api.IFlower;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.control.ControlIconDisplay;
import binnie.core.util.I18N;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.item.ModuleItems;
import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.IButterfly;
import java.text.DecimalFormat;
import java.util.Locale;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageBiology
extends ControlAnalystPage {
    public AnalystPageBiology(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        int fertility;
        IBee bee;
        this.setColor(26214);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (ind instanceof IBee) {
            bee = (IBee)ind;
            if (bee.getGenome().getNeverSleeps()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconAllDay).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.allday"));
            } else if (bee.getGenome().getPrimary().isNocturnal()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconNight).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.night"));
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconDaytime).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.day"));
            }
            if (!bee.getGenome().getToleratesRain()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 24, y, ModuleItems.iconNoRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.norain"));
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 24, y, ModuleItems.iconRain).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.rain"));
            }
            if (bee.getGenome().getCaveDwelling()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 48, y, ModuleItems.iconNoSky).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.nosky"));
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 48, y, ModuleItems.iconSky).addTooltip(I18N.localise("genetics.gui.analyst.biology.bee.sky"));
            }
            y += 30;
        } else if (ind instanceof IButterfly) {
            IButterfly moth = (IButterfly)ind;
            if (moth.getGenome().getNocturnal()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconAllDay).addTooltip("Active all day and night");
            } else if (moth.getGenome().getPrimary().isNocturnal()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconNight).addTooltip("Active at night");
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2, y, ModuleItems.iconDaytime).addTooltip("Active during the day");
            }
            if (!moth.getGenome().getTolerantFlyer()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 24, y, ModuleItems.iconNoRain).addTooltip("Cannot work during rain");
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 24, y, ModuleItems.iconRain).addTooltip("Can work during rain");
            }
            if (moth.getGenome().getFireResist()) {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 48, y, ModuleItems.iconNoFire).addTooltip("Nonflammable");
            } else {
                new ControlIconDisplay((IWidget)this, (this.width() - 64) / 2 + 48, y, ModuleItems.iconFire).addTooltip("Flammable");
            }
            y += 30;
        } else if (ind instanceof ITree) {
            new ControlTextCentered((IWidget)this, y, "\u00a7oSappiness: " + Binnie.GENETICS.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS))).setColor(this.getColor());
            y += 20;
        } else {
            y += 10;
        }
        if (ind instanceof IBee) {
            bee = (IBee)ind;
            fertility = bee.getGenome().getFertility();
            new ControlTextCentered((IWidget)this, y, "\u00a7l" + fertility + "\u00a7r drone" + (fertility > 1 ? "s" : "") + " per hive").setColor(this.getColor());
            int lifespan = bee.getGenome().getLifespan() * 550;
            new ControlTextCentered((IWidget)this, y += 22, "Average Lifespan").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString((float)lifespan * (bee.getGenome().getNeverSleeps() ? 1.0f : 2.0f))).setColor(this.getColor());
            y += 22;
        }
        if (ind instanceof IButterfly) {
            IButterfly bee2 = (IButterfly)ind;
            fertility = bee2.getGenome().getFertility();
            new ControlTextCentered((IWidget)this, y, "Lays \u00a7l" + fertility + "\u00a7r caterpillar" + (fertility > 1 ? "s" : "") + " before dying").setColor(this.getColor());
            float caterpillarMatureTime = 1365.3999f * (float)Math.round(bee2.getGenome().getLifespan() / (bee2.getGenome().getFertility() * 2));
            new ControlTextCentered((IWidget)this, y += 32, "Caterpillar Gestation").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString(caterpillarMatureTime)).setColor(this.getColor());
            int speed = (int)(20.0f * bee2.getGenome().getSpeed());
            new ControlTextCentered((IWidget)this, y += 22, "Flight Speed").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + speed + "\u00a7r blocks per second").setColor(this.getColor());
            y += 22;
        }
        if (ind instanceof ITree) {
            ITree tree = (ITree)ind;
            fertility = (int)(1.0f / tree.getGenome().getFertility());
            new ControlTextCentered((IWidget)this, y, "1 Sapling per \u00a7l" + fertility + "\u00a7r leave" + (fertility > 1 ? "s" : "")).setColor(this.getColor());
            int butterflySpawn = Math.round(1365.3999f / (tree.getGenome().getSappiness() * tree.getGenome().getYield() * 0.5f));
            new ControlTextCentered((IWidget)this, y += 22, "Butterfies spawn every\n" + this.getTimeString(butterflySpawn) + " per leaf").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 34, "Plant Type").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7o" + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)).setColor(this.getColor());
        }
        if (ind instanceof IFlower) {
            IFlower flower = (IFlower)ind;
            int butterflySpawn2 = Math.round(1365.3999f / (flower.getGenome().getSappiness() * 0.2f));
            new ControlTextCentered((IWidget)this, y, "Butterfies spawn every\n" + this.getTimeString(butterflySpawn2)).setColor(this.getColor());
            y += 30;
            float CHANCE_DISPERSAL = 0.8f;
            CHANCE_DISPERSAL += 0.2f * (float)flower.getGenome().getFertility();
            float CHANCE_POLLINATE = 0.6f;
            float CHANCE_SELFPOLLINATE = 0.2f * (CHANCE_POLLINATE += 0.25f * (float)flower.getGenome().getFertility());
            if (CHANCE_DISPERSAL > 1.0f) {
                CHANCE_DISPERSAL = 1.0f;
            }
            if (CHANCE_POLLINATE > 1.0f) {
                CHANCE_POLLINATE = 1.0f;
            }
            float dispersalTime = 1365.3999f / CHANCE_DISPERSAL;
            float pollinateTime = 1365.3999f / CHANCE_POLLINATE;
            float lifespan2 = (float)flower.getMaxAge() * 20.0f * 68.27f / flower.getGenome().getAgeChance();
            float floweringLifespan = (float)(flower.getMaxAge() - 1) * 20.0f * 68.27f / flower.getGenome().getAgeChance();
            new ControlTextCentered((IWidget)this, y, "Average Lifespan").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7l" + this.getMCDayString(lifespan2)).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 22, "Seed Dispersal").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7o" + (int)((floweringLifespan -= 1365.3999f) / dispersalTime) + " per lifetime").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 22, "Pollination").setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 12, "\u00a7o" + (int)(floweringLifespan / pollinateTime) + " per lifetime").setColor(this.getColor());
            y += 22;
        }
        this.setSize(new Point(this.width(), y));
    }

    private String getMCDayString(float time) {
        float seconds = time / 20.0f;
        float minutes = seconds / 60.0f;
        float days = minutes / 20.0f;
        DecimalFormat df = new DecimalFormat("#.0");
        return df.format(days) + " MC days";
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.biology.title");
    }
}

