/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.core.util.FakeCraftingWorld;
import binnie.core.util.OreDictionaryUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class LumbermillRecipes {
    private static Multimap<Item, Pair<ItemStack, ItemStack>> recipes = ArrayListMultimap.create();

    public static ItemStack getPlankProduct(ItemStack logStack) {
        if (recipes.isEmpty()) {
            LumbermillRecipes.calculateLumbermillProducts();
        }
        Item logItem = logStack.func_77973_b();
        for (Pair entry : recipes.get((Object)logItem)) {
            if (!((ItemStack)entry.getKey()).func_77969_a(logStack)) continue;
            return ((ItemStack)entry.getValue()).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static Collection<Pair<ItemStack, ItemStack>> getRecipes() {
        if (recipes.isEmpty()) {
            LumbermillRecipes.calculateLumbermillProducts();
        }
        return recipes.values();
    }

    private static void calculateLumbermillProducts() {
        int plankOreId = OreDictionary.getOreID((String)"plankWood");
        CraftingManager craftingManager = CraftingManager.func_77594_a();
        InventoryCrafting fakeCraftingInventory = new InventoryCrafting((Container)new FakeCraftingHandler(), 3, 3);
        List registeredWoodTypes = TreeManager.woodAccess.getRegisteredWoodTypes();
        for (IWoodType woodType : registeredWoodTypes) {
            ItemStack logStack = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, false);
            ItemStack logCopy = logStack.func_77946_l();
            logCopy.func_190920_e(1);
            fakeCraftingInventory.func_174888_l();
            fakeCraftingInventory.func_70299_a(0, logCopy);
            try {
                ItemStack recipeOutput = craftingManager.func_82787_a(fakeCraftingInventory, (World)FakeCraftingWorld.getInstance());
                if (recipeOutput.func_190926_b() || !OreDictionaryUtil.hasOreId(recipeOutput, plankOreId)) continue;
                Item logItem = logCopy.func_77973_b();
                ItemStack outputCopy = recipeOutput.func_77946_l();
                outputCopy.func_190920_e((int)Math.ceil((float)outputCopy.func_190916_E() * 1.5f));
                recipes.put((Object)logItem, (Object)Pair.of((Object)logCopy, (Object)outputCopy));
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private static class FakeCraftingHandler
    extends Container {
        private FakeCraftingHandler() {
        }

        public void func_75130_a(IInventory inventoryIn) {
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }
}

