/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Infuser {
    public static final int tankInput = 0;
    public static final int tankOutput = 1;
    static Map<Fluid, FluidStack> recipes = new HashMap<Fluid, FluidStack>();

    @Nullable
    public static FluidStack getOutput(FluidStack fluid, ItemStack stack) {
        return recipes.get(fluid.getFluid());
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        return recipes.containsKey(fluid.getFluid());
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (Map.Entry<Fluid, FluidStack> entry : recipes.entrySet()) {
            if (!entry.getValue().isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output) {
        recipes.put(input.getFluid(), output);
    }

    public static class TankValidatorInfuserOutput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Infuser.isValidOutputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Infused Liquids";
        }
    }

    public static class TankValidatorInfuserInput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Infuser.isValidInputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Infusable Liquids";
        }
    }

    public static class ComponentInfuserLogic
    extends ComponentProcessSetCost
    implements IProcess {
        ItemStack infusing;

        public ComponentInfuserLogic(Machine machine) {
            super(machine, 16000, 800);
        }

        @Override
        public int getProcessEnergy() {
            return this.getProcessLength() * 2;
        }

        @Override
        public int getProcessLength() {
            return 20;
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isTankEmpty(0)) {
                return new ErrorState.InsufficientLiquid("No Input Liquid", 0);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            FluidStack outputTankFluid = this.getUtil().getFluid(1);
            if (!this.getUtil().isTankEmpty(1) && this.getOutput() != null && !this.getOutput().isFluidEqual(outputTankFluid)) {
                return new ErrorState.Tank("No Room", "No room for liquid", new int[]{1});
            }
            if (outputTankFluid != null && !outputTankFluid.isFluidEqual(this.getOutput())) {
                return new ErrorState.TankSpace("Different fluid in tank", 1);
            }
            return super.canProgress();
        }

        @Nullable
        private FluidStack getOutput() {
            FluidStack fluid = this.getUtil().getFluid(0);
            if (fluid == null) {
                return null;
            }
            return Infuser.getOutput(fluid, this.infusing);
        }

        @Override
        protected void onFinishTask() {
            FluidStack output = this.getOutput();
            if (output != null) {
                this.getUtil().fillTank(1, output.copy());
            }
        }

        @Override
        protected void onTickTask() {
        }

        @Override
        public String getTooltip() {
            return "Infusing";
        }
    }

    public static class PackageInfuser
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageInfuser() {
            super("infuser", ExtraTreeTexture.Infuser, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Infuser);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            TankSlot input = tanks.addTank(0, "input", 5000);
            input.setValidator(new TankValidatorInfuserInput());
            input.setOutputSides(MachineSide.TopAndBottom);
            TankSlot output = tanks.addTank(1, "output", 5000);
            output.setValidator(new TankValidatorInfuserOutput());
            output.setReadOnly();
            output.setOutputSides(MachineSide.Sides);
            new ComponentPowerReceptor(machine);
            new ComponentInfuserLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

