/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block.wood;

import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.block.property.PropertyETWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockForestrySlab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public abstract class BlockETSlab
extends BlockForestrySlab<EnumETLog> {
    private BlockETSlab(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
        String name = "slabs.";
        if (fireproof) {
            name = name + "fireproof.";
        }
        if (this.func_176552_j()) {
            name = name + "double.";
        }
        name = name + blockNumber;
        this.setRegistryName(new ResourceLocation("extratrees", name));
        this.func_149663_c(name);
    }

    public String func_150002_b(int meta) {
        EnumETLog woodType = this.getWoodType(meta);
        return WoodManager.getDisplayName((IWoodTyped)this, woodType);
    }

    public static List<BlockETSlab> create(boolean fireproof, final boolean doubleSlab) {
        ArrayList<BlockETSlab> blocks = new ArrayList<BlockETSlab>();
        PropertyETWoodType[] variants = PropertyETWoodType.create("variant", 8, false);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyETWoodType variant = variants[i];
            BlockETSlab block = new BlockETSlab(fireproof, i){

                public PropertyETWoodType getVariant() {
                    return variant;
                }

                public boolean func_176552_j() {
                    return doubleSlab;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public EnumETLog getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = (meta &= 0xFFFFFFF7) % variantCount + this.getBlockNumber() * 8;
        return EnumETLog.byMetadata(variantMeta);
    }
}

