/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block.wood;

import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.property.PropertyETWoodType;
import forestry.arboriculture.blocks.BlockForestryLog;
import forestry.arboriculture.blocks.PropertyWoodType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public abstract class BlockETLog
extends BlockForestryLog<EnumETLog> {
    private BlockETLog(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
        String name = "logs.";
        if (fireproof) {
            name = name + "fireproof.";
        }
        name = name + blockNumber;
        this.setRegistryName(new ResourceLocation("extratrees", name));
        this.func_149663_c(name);
    }

    public static List<BlockETLog> create(boolean fireproof) {
        ArrayList<BlockETLog> blocks = new ArrayList<BlockETLog>();
        PropertyETWoodType[] variants = PropertyETWoodType.create("variant", 4, true);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyETWoodType variant = variants[i];
            BlockETLog block = new BlockETLog(fireproof, i){

                public PropertyWoodType<EnumETLog> getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public EnumETLog getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 4;
        return EnumETLog.byMetadata(variantMeta);
    }
}

