/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.util.I18N;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.IFenceProvider;
import binnie.extratrees.block.IPlankType;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlankType {
    public static final int MAX_PLANKS = 256;

    public static void setup() {
        for (VanillaPlanks vanillaPlanks : VanillaPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(vanillaPlanks.ordinal(), vanillaPlanks);
        }
        for (Enum enum_ : ExtraTreePlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 32, (IDesignMaterial)((Object)enum_));
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 128, (IDesignMaterial)((Object)enum_));
        }
    }

    public static enum ForestryPlanks implements IPlankType,
    IFenceProvider
    {
        LARCH(14131085, (IWoodType)EnumForestryWoodType.LARCH),
        TEAK(8223075, (IWoodType)EnumForestryWoodType.TEAK),
        ACACIA(9745287, (IWoodType)EnumForestryWoodType.ACACIA),
        LIME(13544048, (IWoodType)EnumForestryWoodType.LIME),
        CHESTNUT(12298845, (IWoodType)EnumForestryWoodType.CHESTNUT),
        WENGE(6182474, (IWoodType)EnumForestryWoodType.WENGE),
        BAOBAB(9608290, (IWoodType)EnumForestryWoodType.BAOBAB),
        SEQUOIA(10050135, (IWoodType)EnumForestryWoodType.SEQUOIA),
        KAPOK(8156212, (IWoodType)EnumForestryWoodType.KAPOK),
        EBONY(3946288, (IWoodType)EnumForestryWoodType.EBONY),
        MAHOGANY(7749432, (IWoodType)EnumForestryWoodType.MAHOGANY),
        BALSA(0xA9A299, (IWoodType)EnumForestryWoodType.BALSA),
        WILLOW(11710818, (IWoodType)EnumForestryWoodType.WILLOW),
        WALNUT(6836802, (IWoodType)EnumForestryWoodType.WALNUT),
        GREENHEART(5144156, (IWoodType)EnumForestryWoodType.GREENHEART),
        CHERRY(11895348, (IWoodType)EnumForestryWoodType.CHERRY),
        MAHOE(8362154, (IWoodType)EnumForestryWoodType.MAHOE),
        POPLAR(13619074, (IWoodType)EnumForestryWoodType.POPLAR),
        PALM(13271115, (IWoodType)EnumForestryWoodType.PALM),
        PAPAYA(14470005, (IWoodType)EnumForestryWoodType.PAPAYA),
        PINE(12885585, (IWoodType)EnumForestryWoodType.PINE),
        PLUM(11364479, (IWoodType)EnumForestryWoodType.PLUM),
        MAPLE(11431211, (IWoodType)EnumForestryWoodType.MAPLE),
        CITRUS(10266653, (IWoodType)EnumForestryWoodType.CITRUS),
        GIGANTEUM(5186590, (IWoodType)EnumForestryWoodType.GIGANTEUM),
        IPE(5057822, (IWoodType)EnumForestryWoodType.IPE),
        PADAUK(11756341, (IWoodType)EnumForestryWoodType.PADAUK),
        COCOBOLO(7541506, (IWoodType)EnumForestryWoodType.COCOBOLO),
        ZEBRAWOOD(10912334, (IWoodType)EnumForestryWoodType.ZEBRAWOOD);

        private final IWoodType woodType;
        private final int color;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite sprite;

        private ForestryPlanks(int color, IWoodType woodType) {
            this.color = color;
            this.woodType = woodType;
        }

        @Override
        public String getPlankTextureName() {
            return "forestry:blocks/wood/planks." + this.name().toLowerCase();
        }

        @Override
        public String getDesignMaterialName() {
            return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks.forestry." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerSprites(TextureMap map) {
            this.sprite = map.func_174942_a(new ResourceLocation(this.getPlankTextureName()));
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public IWoodType getWoodType() {
            return this.woodType;
        }

        @Override
        public ItemStack getStack(boolean fireproof) {
            return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.PLANKS, fireproof);
        }

        @Override
        public ItemStack getStack() {
            return this.getStack(true);
        }

        @Override
        public ItemStack getFence() {
            return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.FENCE, false);
        }
    }

    public static enum VanillaPlanks implements IPlankType
    {
        OAK(11833434, (IWoodType)EnumVanillaWoodType.OAK),
        SPRUCE(8412726, (IWoodType)EnumVanillaWoodType.SPRUCE),
        BIRCH(14139781, (IWoodType)EnumVanillaWoodType.BIRCH),
        JUNGLE(11632732, (IWoodType)EnumVanillaWoodType.JUNGLE),
        ACACIA(12215095, (IWoodType)EnumVanillaWoodType.ACACIA),
        BIG_OAK(4599061, (IWoodType)EnumVanillaWoodType.DARK_OAK);

        private final IWoodType woodType;
        private int color;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite sprite;

        private VanillaPlanks(int color, IWoodType woodType) {
            this.color = color;
            this.woodType = woodType;
        }

        @Override
        public String getDesignMaterialName() {
            return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase());
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public String getPlankTextureName() {
            return "minecraft:blocks/planks_" + this.name().toLowerCase();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerSprites(TextureMap map) {
            this.sprite = map.func_174942_a(new ResourceLocation(this.getPlankTextureName()));
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getStack() {
            return this.getStack(true);
        }

        @Override
        public IWoodType getWoodType() {
            return this.woodType;
        }

        @Override
        public ItemStack getStack(boolean fireproof) {
            return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.PLANKS, fireproof);
        }
    }

    public static enum ExtraTreePlanks implements IPlankType,
    IFenceProvider,
    IStringSerializable
    {
        Fir(12815444),
        Cedar(14181940),
        Hemlock(13088108),
        Cypress(16169052),
        Fig(13142058),
        Beech(14784849),
        Alder(12092755),
        Hazel(13480341),
        Hornbeam(12818528),
        Box(16511430),
        Butternut(15510138),
        Hickory(14333070),
        Whitebeam(13222585),
        Elm(15772004),
        Apple(6305064),
        Yew(14722426),
        Pear(12093805),
        Hawthorn(13402978),
        Rowan(13610394),
        Elder(12489337),
        Maclura(15970862),
        Syzgium(15123393),
        Brazilwood(7487063),
        Logwood(10762028),
        Iroko(7681024),
        Locust(12816736),
        Eucalyptus(16165771),
        Purpleheart(5970991),
        Ash(16107368),
        Holly(16512743),
        Olive(11578760),
        Sweetgum(13997656),
        Rosewood(7738624),
        Gingko(16050106),
        PinkIvory(15502496),
        Banana(9466691);

        public static final ExtraTreePlanks[] VALUES;
        private final int color;
        private EnumETLog woodType;
        @SideOnly(value=Side.CLIENT)
        private TextureAtlasSprite sprite;

        private ExtraTreePlanks(int color) {
            this.color = color;
        }

        public static void initWoodTypes() {
            Fir.setWoodType(EnumETLog.Fir);
            Cedar.setWoodType(EnumETLog.Cedar);
            Hemlock.setWoodType(EnumETLog.Hemlock);
            Cypress.setWoodType(EnumETLog.Cypress);
            Fig.setWoodType(EnumETLog.Fig);
            Beech.setWoodType(EnumETLog.Beech);
            Alder.setWoodType(EnumETLog.Alder);
            Hazel.setWoodType(EnumETLog.Hazel);
            Hornbeam.setWoodType(EnumETLog.Hornbeam);
            Box.setWoodType(EnumETLog.Box);
            Butternut.setWoodType(EnumETLog.Butternut);
            Hickory.setWoodType(EnumETLog.Hickory);
            Whitebeam.setWoodType(EnumETLog.Whitebeam);
            Elm.setWoodType(EnumETLog.Elm);
            Apple.setWoodType(EnumETLog.Apple);
            Yew.setWoodType(EnumETLog.Yew);
            Pear.setWoodType(EnumETLog.Pear);
            Hawthorn.setWoodType(EnumETLog.Hawthorn);
            Rowan.setWoodType(EnumETLog.Rowan);
            Elder.setWoodType(EnumETLog.Elder);
            Maclura.setWoodType(EnumETLog.Maclura);
            Syzgium.setWoodType(EnumETLog.Syzgium);
            Brazilwood.setWoodType(EnumETLog.Brazilwood);
            Logwood.setWoodType(EnumETLog.Logwood);
            Iroko.setWoodType(EnumETLog.Iroko);
            Locust.setWoodType(EnumETLog.Locust);
            Eucalyptus.setWoodType(EnumETLog.Eucalyptus);
            Purpleheart.setWoodType(EnumETLog.Purpleheart);
            Ash.setWoodType(EnumETLog.Ash);
            Holly.setWoodType(EnumETLog.Holly);
            Olive.setWoodType(EnumETLog.Olive);
            Sweetgum.setWoodType(EnumETLog.Sweetgum);
            Rosewood.setWoodType(EnumETLog.Rosewood);
            Gingko.setWoodType(EnumETLog.Gingko);
            PinkIvory.setWoodType(EnumETLog.PinkIvory);
            Banana.setWoodType(EnumETLog.Banana);
        }

        @Override
        public EnumETLog getWoodType() {
            return this.woodType;
        }

        public void setWoodType(EnumETLog woodType) {
            this.woodType = woodType;
        }

        public String func_176610_l() {
            return "block.planks." + this.toString().toLowerCase();
        }

        @Override
        public String getDesignMaterialName() {
            return I18N.localise("extratrees.block.planks." + this.toString().toLowerCase());
        }

        @Override
        public String getPlankTextureName() {
            return "extratrees:blocks/planks/" + this.name();
        }

        @Override
        public String getDescription() {
            return I18N.localise("extratrees.block.planks." + this.toString().toLowerCase() + ".desc");
        }

        @Override
        public int getColour() {
            return this.color;
        }

        @Override
        public ItemStack getStack(boolean fireproof) {
            return TreeManager.woodAccess.getStack((IWoodType)this.woodType, WoodBlockKind.PLANKS, fireproof);
        }

        @Override
        public ItemStack getStack() {
            return this.getStack(true);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void registerSprites(TextureMap map) {
            this.sprite = map.func_174942_a(new ResourceLocation(this.getPlankTextureName()));
        }

        @Override
        public ItemStack getFence() {
            return TreeManager.woodAccess.getStack((IWoodType)this.woodType, WoodBlockKind.FENCE, false);
        }

        static {
            VALUES = ExtraTreePlanks.values();
        }
    }
}

