/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.items.types;

import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.types.IEBEnumItem;
import com.google.common.base.Objects;
import forestry.api.recipes.RecipeManagers;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumHoneyComb implements IEBEnumItem
{
    BARREN(7564356, 12762791),
    ROTTEN(4084257, 11652233),
    BONE(12895407, 14606017),
    OIL(394760, 2894646),
    COAL(10392696, 3682590),
    FUEL(10252096, 16761856),
    WATER(2568911, 7973065),
    MILK(14145991, 0xFFFFFF),
    FRUIT(8202548, 14372706),
    SEED(0x344F33, 7457902),
    ALCOHOL(4293921, 14604622),
    STONE(9211025, 0xC6C6CC),
    REDSTONE(16422550, 15077392),
    RESIN(16762703, 13208064),
    IC2ENERGY(15332623, 2143177),
    IRON(3552564, 11038808),
    GOLD(3552564, 15125515),
    COPPER(3552564, 13722376),
    TIN(3552564, 0xBDB1BD),
    SILVER(3552564, 0xDBDBDB),
    BRONZE,
    URANIUM(2031360, 4303667),
    CLAY(7034426, 11583702),
    OLD(4535060, 11769444),
    FUNGAL(7234891, 2856003),
    CREOSOTE(10256652, 12429911),
    LATEX(5854529, 11051653),
    ACIDIC(3441987, 1374014),
    VENOMOUS(8198269, 0xFF33FF),
    SLIME(3884860, 8442245),
    BLAZE(16738816, 0xFFCC00),
    COFFEE(5519389, 11763531),
    GLACIAL(5146503, 13366002),
    MINT,
    CITRUS,
    PEAT,
    SHADOW(0, 3545141),
    LEAD(3552564, 10125468),
    BRASS,
    ELECTRUM,
    ZINC(3552564, 15592447),
    TITANIUM(3552564, 11578083),
    TUNGSTEN(3552564, 1249812),
    STEEL,
    IRIDIUM,
    PLATINUM(3552564, 10125468),
    LAPIS(3552564, 4009179),
    SODALITE,
    PYRITE,
    BAUXITE,
    CINNABAR,
    SPHALERITE,
    EMERALD(3552564, 1900291),
    RUBY(3552564, 0xD60000),
    SAPPHIRE(3552564, 673791),
    OLIVINE,
    DIAMOND(3552564, 8371706),
    RED(0xCC4C4C, 0xFF0000),
    YELLOW(0xE5E533, 0xFFDD00),
    BLUE(10072818, 8959),
    GREEN(6717235, 39168),
    BLACK(0x191919, 0x575757),
    WHITE(0xD6D6D6, 0xFFFFFF),
    BROWN(8349260, 6042895),
    ORANGE(15905331, 16751872),
    CYAN(5020082, 65509),
    PURPLE(11691749, 11403519),
    GRAY(0x4C4C4C, 0xBABABA),
    LIGHTBLUE(10072818, 40447),
    PINK(15905484, 16744671),
    LIMEGREEN(8375321, 65288),
    MAGENTA(15040472, 0xFF00CC),
    LIGHTGRAY(0x999999, 0xC9C9C9),
    NICKEL(3552564, 16768764),
    INVAR,
    GLOWSTONE(10919006, 14730249),
    SALTPETER(10919006, 14730249),
    PULP,
    MULCH,
    COMPOST(4338440, 7036475),
    SAWDUST(12561009, 15913854),
    CERTUS(13029631, 3755363),
    ENDERPEARL(3446662, 206368),
    YELLORIUM(2564173, 14019840),
    CYANITE(2564173, 34541),
    BLUTONIUM(2564173, 1769702);

    public int[] colour = new int[0];
    public Map<ItemStack, Float> products = new LinkedHashMap<ItemStack, Float>();
    public boolean active = true;
    public boolean deprecated = false;

    private EnumHoneyComb() {
        this(0xFFFFFF, 0xFFFFFF);
        this.active = false;
        this.deprecated = true;
    }

    private EnumHoneyComb(int colour, int colour2) {
        this.colour = new int[]{colour, colour2};
    }

    public static EnumHoneyComb get(ItemStack itemStack) {
        int i = itemStack.func_77952_i();
        if (i >= 0 && i < EnumHoneyComb.values().length) {
            return EnumHoneyComb.values()[i];
        }
        return EnumHoneyComb.values()[0];
    }

    public void addRecipe() {
        RecipeManagers.centrifugeManager.addRecipe(20, this.get(1), this.products);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ItemStack get(int size) {
        return new ItemStack(ExtraBees.comb, size, this.ordinal());
    }

    @Override
    public String getName(ItemStack stack) {
        return I18N.localise("extrabees.item.comb." + this.name().toLowerCase());
    }

    public boolean addProduct(@Nullable Item item, Float chance) {
        return this.addProduct(new ItemStack((Item)Objects.firstNonNull((Object)item, (Object)Item.func_150898_a((Block)Blocks.field_150350_a))), chance);
    }

    public boolean addProduct(ItemStack item, Float chance) {
        if (item.func_190926_b()) {
            return false;
        }
        this.products.put(item.func_77946_l(), chance);
        return true;
    }

    public void tryAddProduct(ItemStack item, Float chance) {
        this.active = this.addProduct(item, chance);
    }

    public void tryAddProduct(@Nullable Item item, Float chance) {
        this.active = this.addProduct(item, chance);
    }

    public void tryAddProduct(String oreDict, Float chance) {
        if (!OreDictionary.getOres((String)oreDict).isEmpty()) {
            this.tryAddProduct((ItemStack)OreDictionary.getOres((String)oreDict).get(0), chance);
        } else {
            this.active = false;
        }
    }

    public void tryAddProduct(IEBEnumItem type, Float chance) {
        this.tryAddProduct(type.get(1), chance);
        this.active = this.active && type.isActive();
    }

    public void copyProducts(EnumHoneyComb comb) {
        this.products.putAll(comb.products);
    }
}

