/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.effect;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.EntityBeeLightning;
import binnie.extrabees.genetics.effect.FireworkCreator;
import binnie.extrabees.utils.Utils;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import forestry.core.render.ParticleRender;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ExtraBeesEffect implements IAlleleBeeEffect
{
    ECTOPLASM,
    ACID,
    SPAWN_ZOMBIE,
    SPAWN_SKELETON,
    SPAWN_CREEPER,
    LIGHTNING,
    RADIOACTIVE,
    METEOR,
    HUNGER,
    FOOD,
    BLINDNESS,
    CONFUSION,
    FIREWORKS,
    FESTIVAL,
    BIRTHDAY,
    TELEPORT,
    GRAVITY,
    THIEF,
    WITHER,
    WATER,
    SLOW,
    BonemealSapling,
    BonemealFruit,
    BonemealMushroom,
    Power;

    private static final List<Birthday> birthdays;
    private String fx = "";
    private boolean combinable = false;
    private boolean dominant = true;
    private int id;
    private String uid = this.toString().toLowerCase();

    public static void doInit() {
        BLINDNESS.setFX("blindness");
        FOOD.setFX("food");
        GRAVITY.setFX("gravity");
        THIEF.setFX("gravity");
        TELEPORT.setFX("gravity");
        LIGHTNING.setFX("lightning");
        METEOR.setFX("meteor");
        RADIOACTIVE.setFX("radioactive");
        WATER.setFX("water");
        WITHER.setFX("wither");
        for (ExtraBeesEffect effect : ExtraBeesEffect.values()) {
            effect.register();
        }
    }

    public static void doAcid(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150347_e || block == Blocks.field_150348_b) {
            world.func_175656_a(pos, Blocks.field_150351_n.func_176223_P());
        } else if (block == Blocks.field_150346_d | block == Blocks.field_150349_c) {
            world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
        }
    }

    public static int wearsItems(EntityPlayer player) {
        return BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)player, "", false);
    }

    public void register() {
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[0]);
    }

    public boolean isCombinable() {
        return this.combinable;
    }

    public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    public String getName() {
        return I18n.func_74838_a((String)("effect." + this.name().toLowerCase() + ".name"));
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public void spawnMob(World world, BlockPos pos, ResourceLocation name) {
        if (this.anyPlayerInRange(world, pos, 16)) {
            int nearbyEntityCount;
            double var1 = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            double var2 = (float)pos.func_177956_o() + world.field_73012_v.nextFloat();
            double var3 = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, var1, var2, var3, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, var1, var2, var3, 0.0, 0.0, 0.0, new int[0]);
            EntityLiving entity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)name, (World)world);
            if (entity != null && (nearbyEntityCount = world.func_72872_a(entity.getClass(), new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b(8.0, 4.0, 8.0)).size()) < 6) {
                double var6 = (double)pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                double var7 = pos.func_177956_o() + world.field_73012_v.nextInt(3) - 1;
                double var8 = (double)pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * 4.0;
                entity.func_70012_b(var6, var7, var8, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity.func_70601_bi()) {
                    world.func_72838_d((Entity)entity);
                    world.func_175718_b(2004, pos, 0);
                    entity.func_70656_aK();
                }
            }
        }
    }

    private boolean anyPlayerInRange(World world, BlockPos pos, int distance) {
        return world.func_184137_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)distance, false) != null;
    }

    public String getUID() {
        return "extrabees.effect." + this.uid;
    }

    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        int xHouse = housing.getCoordinates().func_177958_n();
        int yHouse = housing.getCoordinates().func_177956_o();
        int zHouse = housing.getCoordinates().func_177952_p();
        Vec3i area = this.getModifiedArea(genome, housing);
        int xd = 1 + area.func_177958_n() / 2;
        int yd = 1 + area.func_177956_o() / 2;
        int zd = 1 + area.func_177952_p() / 2;
        int x1 = xHouse - xd + world.field_73012_v.nextInt(2 * xd + 1);
        int y1 = yHouse - yd + world.field_73012_v.nextInt(2 * yd + 1);
        int z1 = zHouse - zd + world.field_73012_v.nextInt(2 * zd + 1);
        BlockPos pos = new BlockPos(x1, y1, z1);
        switch (this) {
            case ECTOPLASM: {
                if (world.field_73012_v.nextInt(100) >= 4) break;
                if (world.func_175623_d(pos) && (world.func_175677_d(pos.func_177977_b(), false) || world.func_180495_p(pos.func_177977_b()).func_177230_c() == ExtraBees.ectoplasm)) {
                    world.func_175656_a(pos, ExtraBees.ectoplasm.func_176223_P());
                }
                return storedData;
            }
            case ACID: {
                if (world.field_73012_v.nextInt(100) >= 6) break;
                ExtraBeesEffect.doAcid(world, pos);
                break;
            }
            case SPAWN_ZOMBIE: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, pos, new ResourceLocation("zombie"));
                break;
            }
            case SPAWN_SKELETON: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, pos, new ResourceLocation("skeleton"));
                break;
            }
            case SPAWN_CREEPER: {
                if (world.field_73012_v.nextInt(200) >= 2) break;
                this.spawnMob(world, pos, new ResourceLocation("creeper"));
                break;
            }
            case LIGHTNING: {
                if (world.field_73012_v.nextInt(100) >= 1 || !world.func_175710_j(pos) || !(world instanceof WorldServer)) break;
                world.func_72942_c((Entity)new EntityBeeLightning(world, x1, y1, z1));
                break;
            }
            case METEOR: {
                if (world.field_73012_v.nextInt(100) >= 1 || !world.func_175710_j(pos)) break;
                world.func_72838_d((Entity)new EntitySmallFireball(world, (double)x1, (double)(y1 + 64), (double)z1, 0.0, -0.6, 0.0));
                break;
            }
            case RADIOACTIVE: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    int damage = 4;
                    if (entity instanceof EntityPlayer) {
                        int count = ExtraBeesEffect.wearsItems((EntityPlayer)entity);
                        if (count > 3) continue;
                        if (count > 2) {
                            damage = 1;
                        } else if (count > 1) {
                            damage = 2;
                        } else if (count > 0) {
                            damage = 3;
                        }
                    }
                    entity.func_70097_a(DamageSource.field_76377_j, (float)damage);
                }
                break;
            }
            case FOOD: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    player.func_71024_bL().func_75122_a(2, 0.2f);
                }
                break;
            }
            case HUNGER: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
                    player.func_71024_bL().func_75113_a(4.0f);
                    player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100));
                }
                break;
            }
            case BLINDNESS: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
                }
                break;
            }
            case SLOW: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200));
                }
                break;
            }
            case CONFUSION: {
                for (EntityLivingBase entity : this.getEntities(EntityLivingBase.class, genome, housing)) {
                    if (!(entity instanceof EntityPlayer)) continue;
                    EntityPlayer player = (EntityPlayer)entity;
                    if (world.field_73012_v.nextInt(4) < ExtraBeesEffect.wearsItems(player)) continue;
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200));
                }
                break;
            }
            case BIRTHDAY: 
            case FIREWORKS: 
            case FESTIVAL: {
                if (world.field_73012_v.nextInt(this == FIREWORKS ? 8 : 12) >= 1) break;
                FireworkCreator.Firework firework = new FireworkCreator.Firework();
                switch (this) {
                    case BIRTHDAY: {
                        firework.setShape(FireworkCreator.Shape.Star);
                        firework.addColor(0xFFDD00);
                        for (Birthday birthday : birthdays) {
                            if (!birthday.isToday()) continue;
                            firework.addColor(0xFF0000);
                            firework.addColor(65280);
                            firework.addColor(255);
                            firework.setTrail();
                            break;
                        }
                    }
                    case FIREWORKS: {
                        firework.setShape(FireworkCreator.Shape.Ball);
                        firework.addColor(genome.getPrimary().getSpriteColour(0));
                        firework.addColor(genome.getPrimary().getSpriteColour(0));
                        firework.addColor(genome.getPrimary().getSpriteColour(1));
                        firework.addColor(genome.getSecondary().getSpriteColour(0));
                        firework.addColor(genome.getSecondary().getSpriteColour(0));
                        firework.addColor(genome.getPrimary().getSpriteColour(1));
                        firework.setTrail();
                    }
                }
                EntityFireworkRocket var11 = new EntityFireworkRocket(world, (double)x1, (double)y1, (double)z1, firework.getFirework());
                if (!world.func_175710_j(pos)) break;
                world.func_72838_d((Entity)var11);
                break;
            }
            case GRAVITY: {
                List<Entity> entities2 = this.getEntities(Entity.class, genome, housing);
                for (Entity entity2 : entities2) {
                    double dz;
                    double dy;
                    double dx;
                    float entityStrength = 1.0f;
                    if (entity2 instanceof EntityPlayer) {
                        entityStrength *= 100.0f;
                    }
                    if ((dx = (double)x1 - entity2.field_70165_t) * dx + (dy = (double)y1 - entity2.field_70163_u) * dy + (dz = (double)z1 - entity2.field_70161_v) * dz < 2.0) {
                        return storedData;
                    }
                    double strength = 0.5 / (dx * dx + dy * dy + dz * dz) * (double)entityStrength;
                    entity2.func_70024_g(dx * strength, dy * strength, dz * strength);
                }
                break;
            }
            case THIEF: {
                List<EntityPlayer> entities3 = this.getEntities(EntityPlayer.class, genome, housing);
                for (EntityPlayer entity3 : entities3) {
                    double dx = (double)x1 - entity3.field_70165_t;
                    double dy = (double)y1 - entity3.field_70163_u;
                    double dz = (double)z1 - entity3.field_70161_v;
                    if (dx * dx + dy * dy + dz * dz < 2.0) {
                        return storedData;
                    }
                    double strength = 0.5 / (dx * dx + dy * dy + dz * dz);
                    entity3.func_70024_g(-dx * strength, -dy * strength, -dz * strength);
                }
                break;
            }
            case TELEPORT: {
                if (world.field_73012_v.nextInt(80) > 1) {
                    return storedData;
                }
                List<Entity> entities4 = this.getEntities(Entity.class, genome, housing);
                if (entities4.size() == 0) {
                    return storedData;
                }
                Entity entity4 = entities4.get(world.field_73012_v.nextInt(entities4.size()));
                if (!(entity4 instanceof EntityLiving)) {
                    return storedData;
                }
                float jumpDist = 5.0f;
                if (y1 < 4) {
                    y1 = 4;
                }
                if (!world.func_175623_d(pos) || !world.func_175623_d(pos.func_177984_a())) {
                    return storedData;
                }
                entity4.func_70634_a((double)x1, (double)y1, (double)z1);
                ((EntityLiving)entity4).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 160, 10));
                break;
            }
            case WATER: {
                if (world.field_73012_v.nextInt(120) > 1) {
                    return storedData;
                }
                IFluidHandler fluidHandler = (IFluidHandler)Utils.getCapability(world, pos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
                if (fluidHandler == null) break;
                fluidHandler.fill(new FluidStack(FluidRegistry.WATER, 100), true);
                break;
            }
            case BonemealSapling: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return storedData;
                }
                if (!ExtraBeesFlowers.Sapling.isAcceptedFlower(world, pos)) break;
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)pos);
                break;
            }
            case BonemealFruit: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return storedData;
                }
                if (!ExtraBeesFlowers.Fruit.isAcceptedFlower(world, pos)) break;
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)pos);
                break;
            }
            case BonemealMushroom: {
                if (world.field_73012_v.nextInt(20) > 1) {
                    return storedData;
                }
                if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150338_P && world.func_180495_p(pos).func_177230_c() != Blocks.field_150337_Q) break;
                ItemDye.func_179234_a((ItemStack)new ItemStack(Blocks.field_150346_d, 1), (World)world, (BlockPos)pos);
                break;
            }
            case Power: {
                TileEntity tile2 = world.func_175625_s(pos);
                if (!tile2.hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) break;
                IEnergyStorage storage = (IEnergyStorage)tile2.getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP);
                storage.receiveEnergy(5, false);
                break;
            }
        }
        return storedData;
    }

    protected Vec3i getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        Vec3i territory = genome.getTerritory();
        if ((territory = new Vec3i(territory.func_177958_n() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f), territory.func_177956_o() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f), territory.func_177952_p() * (int)(BeeManager.beeRoot.createBeeHousingModifier(housing).getTerritoryModifier(genome, 1.0f) * 3.0f))).func_177958_n() < 1) {
            territory = new Vec3i(1, territory.func_177956_o(), territory.func_177952_p());
        }
        if (territory.func_177956_o() < 1) {
            territory = new Vec3i(territory.func_177958_n(), 1, territory.func_177952_p());
        }
        if (territory.func_177952_p() < 1) {
            territory = new Vec3i(territory.func_177958_n(), territory.func_177956_o(), 1);
        }
        return territory;
    }

    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleRender.addBeeHiveFX((IBeeHousing)housing, (IBeeGenome)genome, (List)flowerPositions);
        return storedData;
    }

    public String getFX() {
        return this.fx;
    }

    private void setFX(String string) {
        this.fx = "particles/" + string;
    }

    public <T extends Entity> List<T> getEntities(Class<T> eClass, IBeeGenome genome, IBeeHousing housing) {
        Vec3i area = genome.getTerritory();
        int[] offset = new int[]{-Math.round(area.func_177958_n() / 2), -Math.round(area.func_177956_o() / 2), -Math.round(area.func_177952_p() / 2)};
        int[] min = new int[]{housing.getCoordinates().func_177958_n() + offset[0], housing.getCoordinates().func_177956_o() + offset[1], housing.getCoordinates().func_177952_p() + offset[2]};
        int[] max = new int[]{housing.getCoordinates().func_177958_n() + offset[0] + area.func_177958_n(), housing.getCoordinates().func_177956_o() + offset[1] + area.func_177956_o(), housing.getCoordinates().func_177952_p() + offset[2] + area.func_177952_p()};
        AxisAlignedBB box = new AxisAlignedBB((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
        return housing.getWorldObj().func_72872_a(eClass, box);
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    static {
        birthdays = new ArrayList<Birthday>();
        birthdays.add(new Birthday(3, 10, "Binnie"));
    }

    public static class Birthday {
        private final int month;
        private final int date;
        private final String name;

        private Birthday(int month, int date, String name) {
            this.month = month;
            this.date = date + 1;
            this.name = name;
        }

        public boolean isToday() {
            return Calendar.getInstance().get(5) == this.date && Calendar.getInstance().get(2) == this.month;
        }

        public String getName() {
            return this.name;
        }
    }
}

