/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.client.BeeModelProvider;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.extrabees.items.ItemHoneyComb;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.items.types.IEBEnumItem;
import binnie.extrabees.utils.Utils;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IModelManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum ExtraBeesSpecies implements IAlleleBeeSpecies
{
    ARID("aridus", 12511316),
    BARREN("infelix", 14733923),
    DESOLATE("desolo", 13744272),
    GNAWING("apica", 15234224),
    ROTTEN("caries", 12574902),
    BONE("os", 15330792),
    CREEPER("erepo", 2942485),
    DECOMPOSING("aegrus", 5388049),
    ROCK("saxum", 0xA8A8A8),
    STONE("lapis", 0x757575),
    GRANITE("granum", 0x695555),
    MINERAL("minerale", 7239037),
    COPPER("cuprous", 13722376),
    TIN("stannus", 0xBDB1BD),
    IRON("ferrous", 11038808),
    LEAD("plumbous", 11373483),
    ZINC("spelta", 15592447),
    TITANIUM("titania", 11578083),
    BRONZE,
    BRASS,
    STEEL,
    TUNGSTATE("wolfram", 1249812),
    GOLD("aureus", 15125515),
    SILVER("argentus", 0xDBDBDB),
    ELECTRUM,
    PLATINUM("platina", 0xDBDBDB),
    LAPIS("lazuli", 4009179),
    SODALITE,
    PYRITE,
    BAUXITE,
    CINNABAR,
    SPHALERITE,
    EMERALD("emerala", 1900291),
    RUBY("ruba", 0xD60000),
    SAPPHIRE("saphhira", 673791),
    OLIVINE,
    DIAMOND("diama", 8371706),
    UNSTABLE("levis", 4099124),
    NUCLEAR("nucleus", 4312111),
    RADIOACTIVE("fervens", 2031360),
    ANCIENT("antiquus", 15915919),
    PRIMEVAL("priscus", 11773563),
    PREHISTORIC("pristinus", 7232064),
    RELIC("sapiens", 5062166),
    COAL("carbo", 8025672),
    RESIN("lacrima", 10908443),
    OIL("lubricus", 5719920),
    PEAT,
    DISTILLED("distilli", 0x356356),
    FUEL("refina", 16760835),
    CREOSOTE("creosota", 9936403),
    LATEX("latex", 4803134),
    WATER("aqua", 9741055),
    RIVER("flumen", 8631252),
    OCEAN("mare", 1912493),
    INK("atramentum", 922695),
    GROWING("tyrelli", 6024152),
    THRIVING("thriva", 3466109),
    BLOOMING("blooma", 704308),
    SWEET("mellitus", 16536049),
    SUGAR("dulcis", 15127520),
    RIPENING("ripa", 11716445),
    FRUIT("pomum", 14375030),
    ALCOHOL("vinum", 15239777),
    FARM("ager", 7723872),
    MILK("lacteus", 0xE3E8E8),
    COFFEE("arabica", 9199152),
    CITRUS,
    MINT,
    SWAMP("paludis", 3500339),
    BOGGY("lama", 7887913),
    FUNGAL("boletus", 13722112),
    MARBLE("marbla", 14076367),
    ROMAN("roman", 11373488),
    GREEK("greco", 8735882),
    CLASSICAL("classica", 8592780),
    BASALT("aceri", 9202025),
    TEMPERED("iratus", 0x8A4848),
    ANGRY,
    VOLCANIC("volcano", 5049356),
    MALICIOUS("acerbus", 7875191),
    INFECTIOUS("contagio", 12070581),
    VIRULENT("morbus", 15733740),
    VISCOUS("liquidus", 608014),
    GLUTINOUS("glutina", 1936423),
    STICKY("lentesco", 1565480),
    CORROSIVE("corrumpo", 4873227),
    CAUSTIC("torrens", 8691997),
    ACIDIC("acidus", 12644374),
    EXCITED("excita", 0xFF4545),
    ENERGETIC("energia", 15218119),
    ECSTATIC("ecstatica", 11482600),
    ARTIC("artica", 11395296),
    FREEZING("glacia", 8119267),
    SHADOW("shadowa", 0x595959),
    DARKENED("darka", 0x332E33),
    ABYSS("abyssba", 2164769),
    RED("rubra", 0xFF0000),
    YELLOW("fulvus", 0xFFDD00),
    BLUE("caeruleus", 8959),
    GREEN("prasinus", 39168),
    BLACK("niger", 0x575757),
    WHITE("albus", 0xFFFFFF),
    BROWN("fuscus", 6042895),
    ORANGE("flammeus", 16751872),
    CYAN("cyana", 65509),
    PURPLE("purpureus", 11403519),
    GRAY("ravus", 0xBABABA),
    LIGHTBLUE("aqua", 40447),
    PINK("rosaceus", 16744671),
    LIMEGREEN("lima", 65288),
    MAGENTA("fuchsia", 0xFF00CC),
    LIGHTGRAY("canus", 0xC9C9C9),
    CELEBRATORY("celeba", 16386666),
    JADED("jadeca", 16386666),
    GLOWSTONE("glowia", 14730779),
    HAZARDOUS("infensus", 11562024),
    NICKEL("claro", 16768764),
    INVAR,
    QUANTUM("quanta", 3655131),
    SPATIAL("spatia", 4987872),
    UNUSUAL("daniella", 5874874),
    YELLORIUM("yellori", 14019840),
    CYANITE("cyanita", 34541),
    BLUTONIUM("caruthus", 1769702),
    MYSTICAL("mystica", 4630306);

    public final Map<ItemStack, Float> allProducts;
    public final Map<ItemStack, Float> allSpecialties;
    private final int primaryColor;
    private final String binomial;
    private final Map<ItemStack, Float> products;
    private final Map<ItemStack, Float> specialties;
    public State state;
    boolean nocturnal;
    private int secondaryColor;
    private EnumTemperature temperature;
    private EnumHumidity humidity;
    private boolean hasEffect;
    private boolean isSecret;
    private boolean isCounted;
    @Nullable
    private IClassification branch;
    private String uid;
    @Nullable
    private Achievement achievement;
    private boolean dominant;
    @Nullable
    private IAllele[] template;

    private ExtraBeesSpecies(String binomial, int colour) {
        this.primaryColor = colour;
        this.secondaryColor = 16768022;
        this.temperature = EnumTemperature.NORMAL;
        this.humidity = EnumHumidity.NORMAL;
        this.hasEffect = false;
        this.isSecret = true;
        this.isCounted = true;
        this.branch = null;
        this.uid = "";
        this.achievement = null;
        this.dominant = true;
        this.products = new LinkedHashMap<ItemStack, Float>();
        this.specialties = new LinkedHashMap<ItemStack, Float>();
        this.allProducts = new LinkedHashMap<ItemStack, Float>();
        this.allSpecialties = new LinkedHashMap<ItemStack, Float>();
        this.state = State.Active;
        this.nocturnal = false;
        this.uid = this.toString().toLowerCase();
        this.binomial = binomial;
    }

    private ExtraBeesSpecies() {
        this("", 0xFFFFFF);
    }

    public static IAllele[] getDefaultTemplate() {
        return Utils.getBeeRoot().getDefaultTemplate();
    }

    public static void doInit() {
        int aridBody = 13362036;
        int rockBody = 0x999999;
        int endBody = 0xD9DE9E;
        for (ExtraBeesSpecies extraBeesSpecies : ExtraBeesSpecies.values()) {
            extraBeesSpecies.importTemplate(ExtraBeesSpecies.getDefaultTemplate());
        }
        ARID.importTemplate(BeeDefinition.MODEST);
        ARID.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        ARID.setHumidity(EnumHumidity.ARID);
        ARID.setFlowerProvider(ExtraBeesFlowers.DEAD.getUID());
        ARID.setTemperatureTolerance(EnumAllele.Tolerance.UP_1);
        ARID.setSecondaryColor(13362036);
        BARREN.importTemplate(ARID);
        BARREN.setFertility(EnumAllele.Fertility.LOW);
        BARREN.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        DESOLATE.importTemplate(BARREN);
        DESOLATE.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        DESOLATE.setEffect(ExtraBeesEffect.HUNGER.getUID());
        DESOLATE.setRecessive();
        DESOLATE.setNocturnal();
        DESOLATE.setHasEffect();
        GNAWING.importTemplate(BARREN);
        GNAWING.setFlowerProvider(ExtraBeesFlowers.WOOD.getUID());
        GNAWING.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.25f));
        GNAWING.addSpecialty(EnumHoneyComb.SAWDUST, Float.valueOf(0.25f));
        ROTTEN.importTemplate(DESOLATE);
        ROTTEN.setNocturnal();
        ROTTEN.setCaveDwelling();
        ROTTEN.setTolerantFlyer();
        ROTTEN.setEffect(ExtraBeesEffect.SPAWN_ZOMBIE.getUID());
        ROTTEN.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        ROTTEN.addSpecialty(EnumHoneyComb.ROTTEN, Float.valueOf(0.1f));
        BONE.importTemplate(ROTTEN);
        BONE.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        BONE.addSpecialty(EnumHoneyComb.BONE, Float.valueOf(0.1f));
        BONE.setEffect(ExtraBeesEffect.SPAWN_SKELETON.getUID());
        CREEPER.importTemplate(ROTTEN);
        CREEPER.setAllDay();
        CREEPER.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        CREEPER.addSpecialty(ItemHoneyComb.VanillaComb.POWDERY.get(), Float.valueOf(0.08f));
        CREEPER.setEffect(ExtraBeesEffect.SPAWN_CREEPER.getUID());
        DECOMPOSING.importTemplate(BARREN);
        DECOMPOSING.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.3f));
        DECOMPOSING.addSpecialty(EnumHoneyComb.COMPOST, Float.valueOf(0.08f));
        ROCK.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.3f));
        ROCK.setIsSecret(false);
        ROCK.setAllDay();
        ROCK.setCaveDwelling();
        ROCK.setTolerantFlyer();
        ROCK.setTemperatureTolerance(EnumAllele.Tolerance.BOTH_1);
        ROCK.setHumidityTolerance(EnumAllele.Tolerance.BOTH_1);
        ROCK.setFlowerProvider(ExtraBeesFlowers.ROCK.getUID());
        ROCK.setFertility(EnumAllele.Fertility.LOW);
        ROCK.setLifespan(EnumAllele.Lifespan.SHORT);
        ROCK.setSecondaryColor(0x999999);
        STONE.importTemplate(ROCK);
        STONE.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.3f));
        STONE.setRecessive();
        STONE.setSecondaryColor(0x999999);
        GRANITE.importTemplate(STONE);
        GRANITE.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.3f));
        GRANITE.setTemperatureTolerance(EnumAllele.Tolerance.BOTH_2);
        GRANITE.setHumidityTolerance(EnumAllele.Tolerance.BOTH_2);
        GRANITE.setSecondaryColor(0x999999);
        MINERAL.importTemplate(GRANITE);
        MINERAL.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.3f));
        MINERAL.setSecondaryColor(0x999999);
        COPPER.importTemplate(MINERAL);
        COPPER.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        COPPER.addSpecialty(EnumHoneyComb.COPPER, Float.valueOf(0.06f));
        COPPER.setSecondaryColor(0x999999);
        TIN.importTemplate(MINERAL);
        TIN.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        TIN.addSpecialty(EnumHoneyComb.TIN, Float.valueOf(0.06f));
        TIN.setSecondaryColor(0x999999);
        IRON.importTemplate(MINERAL);
        IRON.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        IRON.addSpecialty(EnumHoneyComb.IRON, Float.valueOf(0.05f));
        IRON.setRecessive();
        IRON.setSecondaryColor(0x999999);
        LEAD.importTemplate(MINERAL);
        LEAD.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        LEAD.addSpecialty(EnumHoneyComb.LEAD, Float.valueOf(0.5f));
        LEAD.setSecondaryColor(0x999999);
        NICKEL.importTemplate(MINERAL);
        NICKEL.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        NICKEL.addSpecialty(EnumHoneyComb.NICKEL, Float.valueOf(0.05f));
        NICKEL.setSecondaryColor(0x999999);
        ZINC.importTemplate(MINERAL);
        ZINC.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        ZINC.addSpecialty(EnumHoneyComb.ZINC, Float.valueOf(0.05f));
        ZINC.setSecondaryColor(0x999999);
        TITANIUM.importTemplate(MINERAL);
        TITANIUM.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        TITANIUM.addSpecialty(EnumHoneyComb.TITANIUM, Float.valueOf(0.02f));
        TITANIUM.setSecondaryColor(0x999999);
        TUNGSTATE.importTemplate(MINERAL);
        TUNGSTATE.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        TUNGSTATE.addSpecialty(EnumHoneyComb.TUNGSTEN, Float.valueOf(0.01f));
        TUNGSTATE.setSecondaryColor(0x999999);
        GOLD.importTemplate(MINERAL);
        GOLD.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        GOLD.addSpecialty(EnumHoneyComb.GOLD, Float.valueOf(0.02f));
        GOLD.setSecondaryColor(0x999999);
        SILVER.importTemplate(MINERAL);
        SILVER.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        SILVER.addSpecialty(EnumHoneyComb.SILVER, Float.valueOf(0.02f));
        SILVER.setRecessive();
        SILVER.setSecondaryColor(0x999999);
        PLATINUM.importTemplate(MINERAL);
        PLATINUM.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        PLATINUM.addSpecialty(EnumHoneyComb.PLATINUM, Float.valueOf(0.01f));
        PLATINUM.setRecessive();
        PLATINUM.setSecondaryColor(0x999999);
        LAPIS.importTemplate(MINERAL);
        LAPIS.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        LAPIS.addSpecialty(EnumHoneyComb.LAPIS, Float.valueOf(0.05f));
        LAPIS.setSecondaryColor(0x999999);
        EMERALD.importTemplate(MINERAL);
        EMERALD.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        EMERALD.addSpecialty(EnumHoneyComb.EMERALD, Float.valueOf(0.04f));
        EMERALD.setSecondaryColor(0x999999);
        RUBY.importTemplate(MINERAL);
        RUBY.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        RUBY.addSpecialty(EnumHoneyComb.RUBY, Float.valueOf(0.03f));
        RUBY.setSecondaryColor(0x999999);
        SAPPHIRE.importTemplate(MINERAL);
        SAPPHIRE.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        SAPPHIRE.addSpecialty(EnumHoneyComb.SAPPHIRE, Float.valueOf(0.03f));
        SAPPHIRE.setSecondaryColor(0x999999);
        DIAMOND.importTemplate(MINERAL);
        DIAMOND.addProduct(EnumHoneyComb.STONE, Float.valueOf(0.2f));
        DIAMOND.addSpecialty(EnumHoneyComb.DIAMOND, Float.valueOf(0.01f));
        DIAMOND.setSecondaryColor(0x999999);
        UNSTABLE.importTemplate(MINERAL);
        UNSTABLE.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        UNSTABLE.setEffect(ExtraBeesEffect.RADIOACTIVE.getUID());
        UNSTABLE.setFertility(EnumAllele.Fertility.LOW);
        UNSTABLE.setLifespan(EnumAllele.Lifespan.SHORTEST);
        UNSTABLE.setRecessive();
        NUCLEAR.importTemplate(UNSTABLE);
        NUCLEAR.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        NUCLEAR.setRecessive();
        RADIOACTIVE.importTemplate(NUCLEAR);
        RADIOACTIVE.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        RADIOACTIVE.addSpecialty(EnumHoneyComb.URANIUM, Float.valueOf(0.02f));
        RADIOACTIVE.setHasEffect();
        RADIOACTIVE.setRecessive();
        ANCIENT.importTemplate(BeeDefinition.NOBLE);
        ANCIENT.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.3f));
        ANCIENT.setLifespan(EnumAllele.Lifespan.ELONGATED);
        PRIMEVAL.importTemplate(ANCIENT);
        PRIMEVAL.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.3f));
        PRIMEVAL.setLifespan(EnumAllele.Lifespan.LONG);
        PREHISTORIC.importTemplate(ANCIENT);
        PREHISTORIC.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.3f));
        PREHISTORIC.setLifespan(EnumAllele.Lifespan.LONGER);
        PREHISTORIC.setFertility(EnumAllele.Fertility.LOW);
        PREHISTORIC.setRecessive();
        RELIC.importTemplate(ANCIENT);
        RELIC.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.3f));
        RELIC.setHasEffect();
        RELIC.setLifespan(EnumAllele.Lifespan.LONGEST);
        COAL.importTemplate(ANCIENT);
        COAL.setLifespan(EnumAllele.Lifespan.NORMAL);
        COAL.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.2f));
        COAL.addSpecialty(EnumHoneyComb.COAL, Float.valueOf(0.08f));
        RESIN.importTemplate(COAL);
        RESIN.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.2f));
        RESIN.addSpecialty(EnumHoneyComb.RESIN, Float.valueOf(0.05f));
        RESIN.setRecessive();
        OIL.importTemplate(COAL);
        OIL.addProduct(EnumHoneyComb.OLD, Float.valueOf(0.2f));
        OIL.addSpecialty(EnumHoneyComb.OIL, Float.valueOf(0.05f));
        DISTILLED.importTemplate(OIL);
        DISTILLED.addProduct(EnumHoneyComb.OIL, Float.valueOf(0.1f));
        DISTILLED.setRecessive();
        FUEL.importTemplate(OIL);
        FUEL.addProduct(EnumHoneyComb.OIL, Float.valueOf(0.1f));
        FUEL.addSpecialty(EnumHoneyComb.FUEL, Float.valueOf(0.04f));
        FUEL.setHasEffect();
        CREOSOTE.importTemplate(COAL);
        CREOSOTE.addProduct(EnumHoneyComb.COAL, Float.valueOf(0.1f));
        CREOSOTE.addSpecialty(EnumHoneyComb.CREOSOTE, Float.valueOf(0.07f));
        CREOSOTE.setHasEffect();
        LATEX.importTemplate(RESIN);
        LATEX.addProduct(EnumHoneyComb.RESIN, Float.valueOf(0.1f));
        LATEX.addSpecialty(EnumHoneyComb.LATEX, Float.valueOf(0.05f));
        LATEX.setHasEffect();
        WATER.addProduct(EnumHoneyComb.WATER, Float.valueOf(0.3f));
        WATER.setIsSecret(false);
        WATER.setTolerantFlyer();
        WATER.setHumidityTolerance(EnumAllele.Tolerance.BOTH_1);
        WATER.setFlowerProvider(ExtraBeesFlowers.WATER.getUID());
        WATER.setFlowering(EnumAllele.Flowering.SLOW);
        WATER.setEffect(ExtraBeesEffect.WATER.getUID());
        WATER.setHumidity(EnumHumidity.DAMP);
        RIVER.importTemplate(WATER);
        RIVER.addProduct(EnumHoneyComb.WATER, Float.valueOf(0.3f));
        RIVER.addSpecialty(EnumHoneyComb.CLAY, Float.valueOf(0.2f));
        OCEAN.importTemplate(WATER);
        OCEAN.addProduct(EnumHoneyComb.WATER, Float.valueOf(0.3f));
        OCEAN.importTemplate(WATER);
        OCEAN.setRecessive();
        INK.importTemplate(OCEAN);
        INK.addProduct(EnumHoneyComb.WATER, Float.valueOf(0.3f));
        INK.addSpecialty(new ItemStack(Items.field_151100_aR, 1, 0), Float.valueOf(0.1f));
        GROWING.importTemplate(BeeDefinition.FOREST);
        GROWING.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        GROWING.setFlowering(EnumAllele.Flowering.AVERAGE);
        GROWING.setFlowerProvider(ExtraBeesFlowers.LEAVES.getUID());
        THRIVING.importTemplate(GROWING);
        THRIVING.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        THRIVING.setFlowering(EnumAllele.Flowering.FAST);
        BLOOMING.importTemplate(THRIVING);
        BLOOMING.setFlowering(EnumAllele.Flowering.FASTEST);
        BLOOMING.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        BLOOMING.setFlowerProvider(ExtraBeesFlowers.Sapling.getUID());
        BLOOMING.setEffect(ExtraBeesEffect.BonemealSapling.getUID());
        SWEET.importTemplate(BeeDefinition.RURAL);
        SWEET.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.4f));
        SWEET.addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.1f));
        SWEET.setFlowerProvider(ExtraBeesFlowers.SUGAR.getUID());
        SUGAR.importTemplate(SWEET);
        SUGAR.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.4f));
        SUGAR.addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.2f));
        RIPENING.importTemplate(SUGAR);
        RIPENING.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        RIPENING.addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.1f));
        RIPENING.addSpecialty(EnumHoneyComb.FRUIT, Float.valueOf(0.1f));
        RIPENING.setFlowerProvider(ExtraBeesFlowers.Fruit.getUID());
        FRUIT.importTemplate(RIPENING);
        FRUIT.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        FRUIT.addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.15f));
        FRUIT.addSpecialty(EnumHoneyComb.FRUIT, Float.valueOf(0.2f));
        FRUIT.setEffect(ExtraBeesEffect.BonemealFruit.getUID());
        FRUIT.setHasEffect();
        ALCOHOL.importTemplate(SWEET);
        ALCOHOL.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f));
        ALCOHOL.addSpecialty(EnumHoneyComb.ALCOHOL, Float.valueOf(0.1f));
        ALCOHOL.setEffect("forestry.effectDrunkard");
        ALCOHOL.setRecessive();
        FARM.importTemplate(BeeDefinition.RURAL);
        FARM.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f));
        FARM.addSpecialty(EnumHoneyComb.SEED, Float.valueOf(0.1f));
        MILK.importTemplate(BeeDefinition.RURAL);
        MILK.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f));
        MILK.addSpecialty(EnumHoneyComb.MILK, Float.valueOf(0.1f));
        COFFEE.importTemplate(BeeDefinition.RURAL);
        COFFEE.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f));
        COFFEE.addSpecialty(EnumHoneyComb.COFFEE, Float.valueOf(0.08f));
        SWAMP.importTemplate(BeeDefinition.MARSHY);
        SWAMP.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f));
        SWAMP.setHumidity(EnumHumidity.DAMP);
        SWAMP.setEffect(ExtraBeesEffect.SLOW.getUID());
        BOGGY.importTemplate(SWAMP);
        BOGGY.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f));
        BOGGY.importTemplate(SWAMP);
        BOGGY.setRecessive();
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f));
        FUNGAL.addSpecialty(EnumHoneyComb.FUNGAL, Float.valueOf(0.15f));
        FUNGAL.importTemplate(BOGGY);
        FUNGAL.setEffect(ExtraBeesEffect.BonemealMushroom.getUID());
        FUNGAL.setHasEffect();
        BASALT.importTemplate(BeeDefinition.SINISTER);
        BASALT.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f));
        BASALT.setEffect("forestry.effectAggressive");
        BASALT.setSecondaryColor(10101539);
        BASALT.setHumidity(EnumHumidity.ARID);
        BASALT.setTemperature(EnumTemperature.HELLISH);
        TEMPERED.importTemplate(BASALT);
        TEMPERED.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f));
        TEMPERED.setEffect(ExtraBeesEffect.METEOR.getUID());
        TEMPERED.setRecessive();
        TEMPERED.setSecondaryColor(10101539);
        VOLCANIC.importTemplate(TEMPERED);
        VOLCANIC.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f));
        VOLCANIC.addSpecialty(EnumHoneyComb.BLAZE, Float.valueOf(0.1f));
        VOLCANIC.setHasEffect();
        VOLCANIC.setSecondaryColor(10101539);
        MALICIOUS.importTemplate(BeeDefinition.TROPICAL);
        MALICIOUS.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        MALICIOUS.setSecondaryColor(431972);
        MALICIOUS.setHumidity(EnumHumidity.DAMP);
        MALICIOUS.setTemperature(EnumTemperature.WARM);
        INFECTIOUS.importTemplate(MALICIOUS);
        INFECTIOUS.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        INFECTIOUS.setFlowering(EnumAllele.Flowering.SLOW);
        INFECTIOUS.setSecondaryColor(431972);
        VIRULENT.importTemplate(INFECTIOUS);
        VIRULENT.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        VIRULENT.addSpecialty(EnumHoneyComb.VENOMOUS, Float.valueOf(0.12f));
        VIRULENT.setFlowering(EnumAllele.Flowering.AVERAGE);
        VIRULENT.setRecessive();
        VIRULENT.setHasEffect();
        VIRULENT.setSecondaryColor(431972);
        VISCOUS.importTemplate(BeeDefinition.TROPICAL);
        VISCOUS.setEffect(ExtraBeesEffect.ECTOPLASM.getUID());
        VISCOUS.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        VISCOUS.setSecondaryColor(431972);
        VISCOUS.setHumidity(EnumHumidity.DAMP);
        VISCOUS.setSpeed(EnumAllele.Speed.SLOW);
        VISCOUS.setTemperature(EnumTemperature.WARM);
        GLUTINOUS.importTemplate(VISCOUS);
        GLUTINOUS.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        GLUTINOUS.setSpeed(EnumAllele.Speed.NORMAL);
        GLUTINOUS.setSecondaryColor(431972);
        STICKY.importTemplate(GLUTINOUS);
        STICKY.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        STICKY.addSpecialty(EnumHoneyComb.SLIME, Float.valueOf(0.12f));
        STICKY.setSpeed(EnumAllele.Speed.FAST);
        STICKY.setHasEffect();
        STICKY.setSecondaryColor(431972);
        CORROSIVE.importTemplate(STICKY);
        CORROSIVE.setHumidity(EnumHumidity.DAMP);
        CORROSIVE.setTemperature(EnumTemperature.WARM);
        CORROSIVE.setEffect(ExtraBeesEffect.ACID.getUID());
        CORROSIVE.setFlowering(EnumAllele.Flowering.AVERAGE);
        CORROSIVE.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.2f));
        CORROSIVE.setRecessive();
        CORROSIVE.setSecondaryColor(431972);
        CAUSTIC.importTemplate(CORROSIVE);
        CAUSTIC.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        CAUSTIC.addSpecialty(EnumHoneyComb.ACIDIC, Float.valueOf(0.03f));
        CAUSTIC.setSecondaryColor(431972);
        ACIDIC.importTemplate(CAUSTIC);
        ACIDIC.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.2f));
        ACIDIC.addSpecialty(EnumHoneyComb.ACIDIC, Float.valueOf(0.16f));
        ACIDIC.setHasEffect();
        ACIDIC.setSecondaryColor(431972);
        EXCITED.setEffect(ExtraBeesEffect.LIGHTNING.getUID());
        EXCITED.addProduct(EnumHoneyComb.REDSTONE, Float.valueOf(0.1f));
        EXCITED.setCaveDwelling();
        EXCITED.setFlowerProvider(ExtraBeesFlowers.REDSTONE.getUID());
        ENERGETIC.importTemplate(EXCITED);
        ENERGETIC.setEffect(ExtraBeesEffect.LIGHTNING.getUID());
        ENERGETIC.addProduct(EnumHoneyComb.REDSTONE, Float.valueOf(0.12f));
        ENERGETIC.setRecessive();
        ECSTATIC.importTemplate(ENERGETIC);
        ECSTATIC.setEffect(ExtraBeesEffect.Power.getUID());
        ECSTATIC.addProduct(EnumHoneyComb.REDSTONE, Float.valueOf(0.2f));
        ECSTATIC.addSpecialty(EnumHoneyComb.IC2ENERGY, Float.valueOf(0.08f));
        ECSTATIC.setHasEffect();
        ARTIC.importTemplate(BeeDefinition.WINTRY);
        ARTIC.addProduct(ItemHoneyComb.VanillaComb.FROZEN.get(), Float.valueOf(0.25f));
        ARTIC.setTemperature(EnumTemperature.ICY);
        ARTIC.setSecondaryColor(14349811);
        FREEZING.importTemplate(ARTIC);
        FREEZING.addProduct(ItemHoneyComb.VanillaComb.FROZEN.get(), Float.valueOf(0.2f));
        FREEZING.addSpecialty(EnumHoneyComb.GLACIAL, Float.valueOf(0.1f));
        FREEZING.setSecondaryColor(14349811);
        SHADOW.importTemplate(BASALT);
        SHADOW.setNocturnal();
        SHADOW.addProduct(EnumHoneyComb.SHADOW, Float.valueOf(0.05f));
        SHADOW.setEffect(ExtraBeesEffect.BLINDNESS.getUID());
        SHADOW.setAllDay(false);
        SHADOW.setRecessive();
        SHADOW.setSecondaryColor(0x333333);
        DARKENED.importTemplate(SHADOW);
        DARKENED.addProduct(EnumHoneyComb.SHADOW, Float.valueOf(0.1f));
        DARKENED.setNocturnal();
        DARKENED.setSecondaryColor(0x333333);
        ABYSS.importTemplate(DARKENED);
        ABYSS.setNocturnal();
        ABYSS.addProduct(EnumHoneyComb.SHADOW, Float.valueOf(0.25f));
        ABYSS.setEffect(ExtraBeesEffect.WITHER.getUID());
        ABYSS.setHasEffect();
        ABYSS.setSecondaryColor(0x333333);
        CELEBRATORY.importTemplate(BeeDefinition.MERRY);
        CELEBRATORY.setEffect(ExtraBeesEffect.FIREWORKS.getUID());
        GLOWSTONE.importTemplate(BASALT);
        GLOWSTONE.addProduct(EnumHoneyComb.GLOWSTONE, Float.valueOf(0.15f));
        GLOWSTONE.setSecondaryColor(10101539);
        HAZARDOUS.importTemplate(BeeDefinition.AUSTERE);
        HAZARDOUS.addProduct(EnumHoneyComb.SALTPETER, Float.valueOf(0.12f));
        JADED.importTemplate(BeeDefinition.IMPERIAL);
        JADED.setFertility(EnumAllele.Fertility.MAXIMUM);
        JADED.setFlowering(EnumAllele.Flowering.MAXIMUM);
        JADED.setTerritory(EnumAllele.Territory.LARGEST);
        JADED.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        JADED.addSpecialty(new ItemStack((Item)PluginApiculture.getItems().pollenCluster), Float.valueOf(0.2f));
        JADED.setHasEffect();
        JADED.setSecondaryColor(14453483);
        JADED.addSpecialty(EnumHoneyComb.PURPLE, Float.valueOf(0.15f));
        ExtraBeesSpecies.JADED.isCounted = false;
        UNUSUAL.importTemplate(BeeDefinition.ENDED);
        UNUSUAL.setEffect(ExtraBeesEffect.GRAVITY.getUID());
        UNUSUAL.setSecondaryColor(12231403);
        UNUSUAL.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f));
        SPATIAL.importTemplate(UNUSUAL);
        SPATIAL.setEffect(ExtraBeesEffect.GRAVITY.getUID());
        SPATIAL.setSecondaryColor(10768076);
        SPATIAL.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f));
        SPATIAL.addSpecialty(EnumHoneyComb.CERTUS, Float.valueOf(0.05f));
        QUANTUM.setEffect(ExtraBeesEffect.TELEPORT.getUID());
        QUANTUM.setSecondaryColor(13963227);
        QUANTUM.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f));
        QUANTUM.addSpecialty(EnumHoneyComb.CERTUS, Float.valueOf(0.15f));
        QUANTUM.addSpecialty(EnumHoneyComb.ENDERPEARL, Float.valueOf(0.15f));
        YELLORIUM.importTemplate(NUCLEAR);
        YELLORIUM.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        YELLORIUM.addSpecialty(EnumHoneyComb.YELLORIUM, Float.valueOf(0.02f));
        YELLORIUM.setEffect(ExtraBeesEffect.RADIOACTIVE.getUID());
        YELLORIUM.setFertility(EnumAllele.Fertility.LOW);
        YELLORIUM.setLifespan(EnumAllele.Lifespan.SHORTEST);
        CYANITE.importTemplate(YELLORIUM);
        CYANITE.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        CYANITE.addSpecialty(EnumHoneyComb.CYANITE, Float.valueOf(0.01f));
        BLUTONIUM.importTemplate(CYANITE);
        BLUTONIUM.addProduct(EnumHoneyComb.BARREN, Float.valueOf(0.2f));
        BLUTONIUM.addSpecialty(EnumHoneyComb.BLUTONIUM, Float.valueOf(0.01f));
        MARBLE.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        MARBLE.importTemplate(BeeDefinition.NOBLE);
        ROMAN.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        ROMAN.importTemplate(MARBLE);
        GREEK.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        GREEK.setRecessive();
        GREEK.importTemplate(ROMAN);
        CLASSICAL.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f));
        CLASSICAL.addSpecialty(PluginApiculture.getItems().royalJelly.getItemStack(), Float.valueOf(0.25f));
        CLASSICAL.setHasEffect();
        CLASSICAL.importTemplate(GREEK);
        MYSTICAL.importTemplate(BeeDefinition.NOBLE);
        for (Map.Entry entry : Utils.getSpecies(BeeDefinition.NOBLE).getProductChances().entrySet()) {
            MYSTICAL.addProduct((ItemStack)entry.getKey(), (Float)entry.getValue());
        }
        MYSTICAL.setFlowerProvider(ExtraBeesFlowers.Mystical.getUID());
        ExtraBeesSpecies[] extraBeesSpeciesArray = ExtraBeesSpecies.values();
        int n = extraBeesSpeciesArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = extraBeesSpeciesArray[i];
            if (((ExtraBeesSpecies)((Object)object)).state != State.Active) {
                AlleleManager.alleleRegistry.blacklistAllele(((ExtraBeesSpecies)((Object)object)).getUID());
            }
            for (EnumBeeChromosome chromo : EnumBeeChromosome.values()) {
                IAllele allele;
                if (chromo == EnumBeeChromosome.HUMIDITY_TOLERANCE || (allele = ((ExtraBeesSpecies)((Object)object)).getTemplate()[chromo.ordinal()]) != null && chromo.getAlleleClass().isInstance(allele)) continue;
                throw new RuntimeException(((ExtraBeesSpecies)((Object)object)).getName() + " has an invalid " + chromo.toString() + " chromosome!");
            }
        }
        for (int i = 0; i < 16; ++i) {
            ExtraBeesSpecies extraBeesSpecies = ExtraBeesSpecies.values()[RED.ordinal() + i];
            EnumHoneyComb comb = EnumHoneyComb.values()[EnumHoneyComb.RED.ordinal() + i];
            extraBeesSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f));
            extraBeesSpecies.addSpecialty(comb, Float.valueOf(0.25f));
            extraBeesSpecies.setSecondaryColor(9240320);
        }
        for (ExtraBeesSpecies extraBeesSpecies : ExtraBeesSpecies.values()) {
            extraBeesSpecies.registerTemplate();
            ExtraBees.proxy.registerBeeModel(extraBeesSpecies);
        }
    }

    public String getName() {
        return ExtraBees.proxy.localiseWithOutPrefix(this.getUnlocalizedName());
    }

    public String getDescription() {
        return ExtraBees.proxy.localiseWithOutPrefix(this.getUID() + ".desc");
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    private void setTemperature(EnumTemperature temperature) {
        this.temperature = temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    private void setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return "Binnie";
    }

    public IClassification getBranch() {
        return this.branch;
    }

    void setBranch(IClassification branch) {
        this.branch = branch;
    }

    public String getUID() {
        return "extrabees.species." + this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public Map<ItemStack, Float> getProducts() {
        return this.products;
    }

    public Map<ItemStack, Float> getSpecialty() {
        return this.specialties;
    }

    private void setState(State state) {
        this.state = state;
    }

    public void registerTemplate() {
        Utils.getBeeRoot().registerTemplate(this.getTemplate());
        if (this.state != State.Active) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
    }

    public void addProduct(ItemStack product, Float chance) {
        if (product.func_190926_b()) {
            this.setState(State.Inactive);
        } else {
            this.products.put(product, chance);
            this.allProducts.put(product, chance);
        }
    }

    public void addProduct(IEBEnumItem product, Float chance) {
        if (product.isActive()) {
            this.addProduct(product.get(1), chance);
        } else {
            this.allProducts.put(product.get(1), chance);
            this.setState(State.Inactive);
        }
    }

    public void addSpecialty(ItemStack product, Float chance) {
        if (product.func_190926_b()) {
            this.setState(State.Inactive);
        } else {
            this.specialties.put(product, chance);
            this.allSpecialties.put(product, chance);
        }
    }

    private void addSpecialty(IEBEnumItem product, Float chance) {
        if (product.isActive()) {
            this.addSpecialty(product.get(1), chance);
        } else {
            this.setState(State.Inactive);
            this.allSpecialties.put(product.get(1), chance);
        }
    }

    public IAllele[] getTemplate() {
        Preconditions.checkState((this.template != null ? 1 : 0) != 0, (String)"Species Template has not been set: %s", (Object[])new Object[]{this.name()});
        this.template[EnumBeeChromosome.SPECIES.ordinal()] = this;
        return this.template;
    }

    public void importTemplate(BeeDefinition species) {
        this.importTemplate(species.getTemplate());
    }

    public void importTemplate(ExtraBeesSpecies species) {
        this.importTemplate(species.getTemplate());
    }

    public void importTemplate(IAllele[] template) {
        IAllele[] templateCopy = (IAllele[])template.clone();
        this.setHumidity(((IAlleleSpecies)template[0]).getHumidity());
        this.setTemperature(((IAlleleSpecies)template[0]).getTemperature());
        this.setSecondaryColor(((IAlleleSpecies)template[0]).getSpriteColour(1));
        templateCopy[EnumBeeChromosome.SPECIES.ordinal()] = this;
        this.template = templateCopy;
    }

    public void setRecessive() {
        this.dominant = false;
    }

    public void setIsSecret(boolean secret) {
        this.isSecret = secret;
    }

    public void setHasEffect() {
        this.hasEffect = true;
    }

    public void setSecondaryColor(int colour) {
        this.secondaryColor = colour;
    }

    public boolean isJubilant(World world, int biomeid, int x, int y, int z) {
        return true;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    public IBeeRoot getRoot() {
        return Utils.getBeeRoot();
    }

    public boolean isNocturnal() {
        return this.nocturnal;
    }

    public void setNocturnal() {
        this.nocturnal = true;
    }

    public void setAllDay() {
        this.setAllDay(true);
    }

    public void setAllDay(boolean allDay) {
        this.getTemplate()[EnumBeeChromosome.NEVER_SLEEPS.ordinal()] = allDay ? AlleleManager.alleleRegistry.getAllele("forestry.boolTrue") : AlleleManager.alleleRegistry.getAllele("forestry.boolFalse");
    }

    public void setCaveDwelling() {
        this.getTemplate()[EnumBeeChromosome.CAVE_DWELLING.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setTolerantFlyer() {
        this.getTemplate()[EnumBeeChromosome.TOLERATES_RAIN.ordinal()] = AlleleManager.alleleRegistry.getAllele("forestry.boolTrue");
    }

    public void setFlowerProvider(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleFlowers) {
            this.getTemplate()[EnumBeeChromosome.FLOWER_PROVIDER.ordinal()] = allele;
        }
    }

    public void setEffect(String uid) {
        IAllele allele = AlleleManager.alleleRegistry.getAllele(uid);
        if (allele instanceof IAlleleBeeEffect) {
            this.getTemplate()[EnumBeeChromosome.EFFECT.ordinal()] = AlleleManager.alleleRegistry.getAllele(uid);
        }
    }

    private void setFertility(EnumAllele.Fertility fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)fert);
    }

    private void setLifespan(EnumAllele.Lifespan fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)fert);
    }

    private void setSpeed(EnumAllele.Speed fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)fert);
    }

    private void setTerritory(EnumAllele.Territory fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)fert);
    }

    private void setFlowering(EnumAllele.Flowering fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)fert);
    }

    private void setHumidityTolerance(EnumAllele.Tolerance fert) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)fert);
    }

    private void setTemperatureTolerance(EnumAllele.Tolerance both1) {
        AlleleHelper.getInstance().set(this.getTemplate(), (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)both1);
    }

    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return 0.0f;
        }
        for (ItemStack itemStack : this.products.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack : this.specialties.keySet()) {
            if (!itemStack.func_77969_a(itemstack)) continue;
            return 1.0f;
        }
        if (itemstack.func_77973_b() == Items.field_151069_bo) {
            return 0.9f;
        }
        if (itemstack.func_77973_b() == PluginApiculture.getItems().honeyDrop) {
            return 0.5f;
        }
        if (itemstack.func_77973_b() == PluginApiculture.getItems().honeydew) {
            return 0.7f;
        }
        if (itemstack.func_77973_b() == PluginApiculture.getItems().beeComb) {
            return 0.4f;
        }
        if (AlleleManager.alleleRegistry.isIndividual(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!((ItemStack)entry.getKey()).func_77969_a(itemstack)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public NonNullList<ItemStack> getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        ItemStack stack2;
        List combinations;
        NonNullList bounty = NonNullList.func_191196_a();
        ItemStack research = null;
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[0]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]);
        }
        if (research != null) {
            bounty.add(research);
        }
        if (bountyLevel > 10) {
            for (ItemStack stack : this.specialties.keySet()) {
                stack2 = stack.func_77946_l();
                stack2.func_190920_e(world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1);
                bounty.add((Object)stack2);
            }
        }
        for (ItemStack stack : this.products.keySet()) {
            stack2 = stack.func_77946_l();
            stack2.func_190920_e(world.field_73012_v.nextInt((int)((float)bountyLevel / 2.0f)) + 1);
            bounty.add((Object)stack2);
        }
        return bounty;
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        boolean own = true;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, (IChromosomeType)EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return 1 + (highest < 0 ? 0 : highest);
    }

    public String getUnlocalizedName() {
        return this.getUID() + ".name";
    }

    public Map<ItemStack, Float> getProductChances() {
        return this.getProducts();
    }

    public Map<ItemStack, Float> getSpecialtyChances() {
        return this.getSpecialty();
    }

    public int getSpriteColour(int renderPass) {
        return renderPass == 0 ? this.primaryColor : (renderPass == 1 ? this.secondaryColor : 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(EnumBeeType type) {
        return BeeModelProvider.instance.getModel(type);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, @Nonnull IModelManager manager) {
        BeeModelProvider.instance.registerModels(item, manager);
    }

    public static enum State {
        Active,
        Inactive,
        Deprecated;

    }
}

