/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.util.I18N;
import binnie.extrabees.genetics.ExtraBeesSpecies;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;

public enum ExtraBeesBranch implements IClassification
{
    BARREN("Vacapis"),
    HOSTILE("Infenapis"),
    ROCKY("Monapis"),
    METALLIC("Lamminapis"),
    METALLIC2("Metalapis"),
    ALLOY("Allapis"),
    PRECIOUS("Pluriapis"),
    MINERAL("Niphapis"),
    GEMSTONE("Gemmapis"),
    NUCLEAR("Levapis"),
    HISTORIC("Priscapis"),
    FOSSILIZED("Fosiapis"),
    REFINED("Petrapis"),
    AQUATIC("Aquapis"),
    SACCHARINE("Sacchapis"),
    CLASSICAL("Grecapis"),
    VOLCANIC("Irrapis"),
    VIRULENT("Virapis"),
    VISCOUS("Viscapis"),
    CAUSTIC("Morbapis"),
    ENERGETIC("Incitapis"),
    FARMING("Agriapis"),
    SHADOW("Pullapis"),
    PRIMARY("Primapis"),
    SECONDARY("Secapis"),
    TERTIARY("Tertiapis"),
    FTB("Eftebeapis"),
    QUANTUM("Quantapis"),
    BOTANIA("Botaniapis");

    IClassification parent;
    private String uid = "";
    private String scientific = "";
    private Set<IAlleleBeeSpecies> speciesSet = new LinkedHashSet<IAlleleBeeSpecies>();

    private ExtraBeesBranch(String scientific) {
        this.scientific = scientific;
        this.uid = this.toString().toLowerCase();
    }

    public static void setSpeciesBranches() {
        IClassification austereBranch;
        IClassification festiveBranch;
        IClassification boggyBranch;
        IClassification agrarianBranch;
        IClassification frozenBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.frozen");
        if (frozenBranch != null) {
            frozenBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ARTIC);
            ExtraBeesSpecies.ARTIC.setBranch(frozenBranch);
            frozenBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.FREEZING);
            ExtraBeesSpecies.FREEZING.setBranch(frozenBranch);
        }
        if ((agrarianBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.agrarian")) != null) {
            agrarianBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.FARM);
            ExtraBeesSpecies.FARM.setBranch(agrarianBranch);
            ExtraBeesSpecies.GROWING.setBranch(agrarianBranch);
            ExtraBeesSpecies.THRIVING.setBranch(agrarianBranch);
            ExtraBeesSpecies.BLOOMING.setBranch(agrarianBranch);
        }
        if ((boggyBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.boggy")) != null) {
            boggyBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SWAMP);
            boggyBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BOGGY);
            boggyBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.FUNGAL);
            ExtraBeesSpecies.SWAMP.setBranch(boggyBranch);
            ExtraBeesSpecies.BOGGY.setBranch(boggyBranch);
            ExtraBeesSpecies.FUNGAL.setBranch(boggyBranch);
        }
        if ((festiveBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.festive")) != null) {
            festiveBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CELEBRATORY);
            ExtraBeesSpecies.CELEBRATORY.setBranch(festiveBranch);
        }
        if ((austereBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.austere")) != null) {
            austereBranch.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.HAZARDOUS);
            ExtraBeesSpecies.HAZARDOUS.setBranch(austereBranch);
        }
        FARMING.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ALCOHOL);
        FARMING.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MILK);
        FARMING.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.COFFEE);
        FARMING.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CITRUS);
        FARMING.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MINT);
        FARMING.register();
        BARREN.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ARID);
        BARREN.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BARREN);
        BARREN.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.DESOLATE);
        BARREN.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.DECOMPOSING);
        BARREN.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GNAWING);
        BARREN.register();
        HOSTILE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ROTTEN);
        HOSTILE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BONE);
        HOSTILE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CREEPER);
        HOSTILE.register();
        ROCKY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ROCK);
        ROCKY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.STONE);
        ROCKY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GRANITE);
        ROCKY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MINERAL);
        ROCKY.register();
        METALLIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.IRON);
        METALLIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.COPPER);
        METALLIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.TIN);
        METALLIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LEAD);
        METALLIC.register();
        METALLIC2.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.NICKEL);
        METALLIC2.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ZINC);
        METALLIC2.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.TUNGSTATE);
        METALLIC2.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.TITANIUM);
        METALLIC2.register();
        ALLOY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BRONZE);
        ALLOY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BRASS);
        ALLOY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.STEEL);
        ALLOY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.INVAR);
        ALLOY.register();
        PRECIOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SILVER);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GOLD);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ELECTRUM);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PLATINUM);
        PRECIOUS.register();
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LAPIS);
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SODALITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PYRITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BAUXITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CINNABAR);
        MINERAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SPHALERITE);
        MINERAL.register();
        GEMSTONE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.EMERALD);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RUBY);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SAPPHIRE);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.OLIVINE);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.DIAMOND);
        GEMSTONE.register();
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.UNSTABLE);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.NUCLEAR);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RADIOACTIVE);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.YELLORIUM);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CYANITE);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BLUTONIUM);
        NUCLEAR.register();
        HISTORIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ANCIENT);
        HISTORIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PRIMEVAL);
        HISTORIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PREHISTORIC);
        HISTORIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RELIC);
        HISTORIC.register();
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.COAL);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RESIN);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.OIL);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PEAT);
        FOSSILIZED.register();
        REFINED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.DISTILLED);
        REFINED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.FUEL);
        REFINED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CREOSOTE);
        REFINED.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LATEX);
        REFINED.register();
        AQUATIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.WATER);
        AQUATIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RIVER);
        AQUATIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.OCEAN);
        AQUATIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.INK);
        AQUATIC.register();
        SACCHARINE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SWEET);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SUGAR);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.FRUIT);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RIPENING);
        SACCHARINE.register();
        CLASSICAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MARBLE);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ROMAN);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GREEK);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CLASSICAL);
        CLASSICAL.register();
        VOLCANIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BASALT);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.TEMPERED);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ANGRY);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.VOLCANIC);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GLOWSTONE);
        VOLCANIC.register();
        VISCOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.VISCOUS);
        VISCOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GLUTINOUS);
        VISCOUS.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.STICKY);
        VISCOUS.register();
        VIRULENT.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MALICIOUS);
        VIRULENT.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.INFECTIOUS);
        VIRULENT.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.VIRULENT);
        VIRULENT.register();
        CAUSTIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CORROSIVE);
        CAUSTIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CAUSTIC);
        CAUSTIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ACIDIC);
        CAUSTIC.register();
        ENERGETIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.EXCITED);
        ENERGETIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ENERGETIC);
        ENERGETIC.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ECSTATIC);
        ENERGETIC.register();
        SHADOW.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SHADOW);
        SHADOW.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.DARKENED);
        SHADOW.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ABYSS);
        SHADOW.register();
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.RED);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.YELLOW);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BLUE);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GREEN);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BLACK);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.WHITE);
        PRIMARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.BROWN);
        PRIMARY.register();
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.ORANGE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.CYAN);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PURPLE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.GRAY);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LIGHTBLUE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.PINK);
        SECONDARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LIMEGREEN);
        SECONDARY.register();
        TERTIARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MAGENTA);
        TERTIARY.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.LIGHTGRAY);
        TERTIARY.register();
        FTB.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.JADED);
        FTB.register();
        QUANTUM.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.UNUSUAL);
        QUANTUM.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.SPATIAL);
        QUANTUM.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.QUANTUM);
        QUANTUM.register();
        BOTANIA.addMemberSpecies((IAlleleSpecies)ExtraBeesSpecies.MYSTICAL);
        BOTANIA.register();
    }

    public String getUID() {
        return "extrabees.genus." + this.uid;
    }

    public String getName() {
        return I18N.localise("extrabees.branch." + this.toString().toLowerCase() + ".name");
    }

    public String getScientific() {
        return this.scientific;
    }

    public String getDescription() {
        return I18N.localise("extrabees.branch." + this.toString().toLowerCase() + ".desc");
    }

    public void register() {
        if (!this.speciesSet.isEmpty()) {
            AlleleManager.alleleRegistry.registerClassification((IClassification)this);
            IClassification parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
            if (parent != null) {
                parent.addMemberGroup((IClassification)this);
                this.setParent(parent);
            }
        }
    }

    public IClassification.EnumClassLevel getLevel() {
        return IClassification.EnumClassLevel.GENUS;
    }

    @Nullable
    public IClassification[] getMemberGroups() {
        return null;
    }

    public void addMemberGroup(IClassification group) {
    }

    public IAlleleSpecies[] getMemberSpecies() {
        return this.speciesSet.toArray(new IAlleleSpecies[0]);
    }

    public void addMemberSpecies(IAlleleSpecies species) {
        this.speciesSet.add((IAlleleBeeSpecies)species);
        if (species instanceof ExtraBeesSpecies) {
            ((ExtraBeesSpecies)species).setBranch(this);
        }
    }

    public IClassification getParent() {
        return this.parent;
    }

    public void setParent(IClassification parent) {
        this.parent = parent;
    }
}

