/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.window;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Panel
extends Control {
    IPanelType type;

    public Panel(IWidget parent, int x, int y, int width, int height, IPanelType type) {
        super(parent, x, y, width, height);
        this.type = type;
    }

    public Panel(IWidget parent, Area area, IPanelType type) {
        this(parent, area.xPos(), area.yPos(), area.width(), area.height(), type);
    }

    public IPanelType getType() {
        return this.type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        IPanelType panelType = this.getType();
        if (panelType instanceof MinecraftGUI.PanelType) {
            switch ((MinecraftGUI.PanelType)panelType) {
                case Black: {
                    CraftGUI.render.texture((Object)CraftGUITexture.PanelBlack, this.getArea());
                    break;
                }
                case Gray: {
                    CraftGUI.render.texture((Object)CraftGUITexture.PanelGray, this.getArea());
                    break;
                }
                case Tinted: {
                    CraftGUI.render.texture((Object)CraftGUITexture.PanelTinted, this.getArea());
                    break;
                }
                case Outline: {
                    CraftGUI.render.texture((Object)CraftGUITexture.Outline, this.getArea());
                    break;
                }
                case TabOutline: {
                    CraftGUI.render.texture((Object)CraftGUITexture.TabOutline, this.getArea());
                    break;
                }
            }
        }
    }

    public static interface IPanelType {
    }
}

