/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.renderer;

import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Border;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.renderer.RenderUtil;
import binnie.core.craftgui.resource.IStyleSheet;
import binnie.core.craftgui.resource.Texture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TextureRenderer {
    private IStyleSheet styleSheet;

    private static void renderTexturePadded(Area area, Area texture, Border padding) {
        int texturingHeight2;
        int texturingWidth;
        int borderLeft = padding.l();
        int borderRight = padding.r();
        int borderTop = padding.t();
        int borderBottom = padding.b();
        int posX = area.pos().x();
        int posY = area.pos().y();
        int width = area.size().x();
        int height = area.size().y();
        int textWidth = texture.width();
        int textHeight = texture.height();
        int u = texture.xPos();
        int v = texture.yPos();
        if (borderTop + borderBottom > height) {
            borderTop = height / 2;
            borderBottom = height / 2;
        }
        if (borderLeft + borderRight > width) {
            borderLeft = width / 2;
            borderRight = width / 2;
        }
        Point origin = area.pos();
        GuiUtils.drawTexturedModalRect((int)posX, (int)posY, (int)u, (int)v, (int)borderLeft, (int)borderTop, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(posX + width - borderRight), (int)posY, (int)(u + textWidth - borderRight), (int)v, (int)borderRight, (int)borderTop, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)posX, (int)(posY + height - borderBottom), (int)u, (int)(v + textHeight - borderBottom), (int)borderLeft, (int)borderBottom, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(posX + width - borderRight), (int)(posY + height - borderBottom), (int)(u + textWidth - borderRight), (int)(v + textHeight - borderBottom), (int)borderRight, (int)borderBottom, (float)0.0f);
        block0: for (int currentXPos = borderLeft; currentXPos < width - borderRight; currentXPos += texturingWidth) {
            int texturingHeight;
            texturingWidth = textWidth - borderLeft - borderRight;
            int distanceXRemaining = width - borderRight - currentXPos;
            if (texturingWidth > distanceXRemaining) {
                texturingWidth = distanceXRemaining;
            }
            if (texturingWidth <= 0) break;
            GuiUtils.drawTexturedModalRect((int)(posX + currentXPos), (int)posY, (int)(u + borderLeft), (int)v, (int)texturingWidth, (int)borderTop, (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)(posX + currentXPos), (int)(posY + height - borderBottom), (int)(u + borderLeft), (int)(v + textHeight - borderBottom), (int)texturingWidth, (int)borderBottom, (float)0.0f);
            for (int currentYPos = borderTop; currentYPos < height - borderBottom; currentYPos += texturingHeight) {
                texturingHeight = textHeight - borderTop - borderBottom;
                int distanceYRemaining = height - borderBottom - currentYPos;
                if (texturingHeight > distanceYRemaining) {
                    texturingHeight = distanceYRemaining;
                }
                if (texturingHeight <= 0) continue block0;
                GuiUtils.drawTexturedModalRect((int)(posX + currentXPos), (int)(posY + currentYPos), (int)(u + borderLeft), (int)(v + borderTop), (int)texturingWidth, (int)texturingHeight, (float)0.0f);
            }
        }
        for (int currentYPos2 = borderTop; currentYPos2 < height - borderBottom; currentYPos2 += texturingHeight2) {
            texturingHeight2 = textHeight - borderTop - borderBottom;
            int distanceYRemaining2 = height - borderBottom - currentYPos2;
            if (texturingHeight2 > distanceYRemaining2) {
                texturingHeight2 = distanceYRemaining2;
            }
            if (texturingHeight2 <= 0) break;
            GuiUtils.drawTexturedModalRect((int)posX, (int)(posY + currentYPos2), (int)u, (int)(v + borderTop), (int)borderLeft, (int)texturingHeight2, (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)(posX + width - borderRight), (int)(posY + currentYPos2), (int)(u + textWidth - borderRight), (int)(v + borderTop), (int)borderRight, (int)texturingHeight2, (float)0.0f);
        }
    }

    public void setStyleSheet(IStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public final void preRender(IWidget widget, int guiWidth, int guiHeight) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)widget.getPosition().x(), (float)widget.getPosition().y(), (float)0.0f);
        RenderUtil.setColour(widget.getColor());
        if (widget.isCroppedWidet()) {
            IWidget cropRelative = widget.getCropWidget() != null ? widget.getCropWidget() : widget;
            Point pos = cropRelative.getAbsolutePosition();
            Area cropZone = widget.getCroppedZone();
            GL11.glEnable((int)3089);
            this.limitArea(new Area(pos.add(cropZone.pos()), cropZone.size()), guiWidth, guiHeight);
        }
        GlStateManager.func_179097_i();
    }

    public final void postRender(IWidget widget) {
        if (widget.isCroppedWidet()) {
            GL11.glDisable((int)3089);
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }

    public Texture getTexture(Object key) {
        if (key instanceof Texture) {
            return (Texture)key;
        }
        return this.styleSheet.getTexture(key);
    }

    public void setTexture(@Nullable Texture texture) {
        if (texture != null) {
            BinnieCore.getBinnieProxy().bindTexture(texture.getFilename());
        }
    }

    public void texture(Object texture, Point position) {
        this.texture(this.getTexture(texture), position);
    }

    public void texture(@Nullable Texture texture, Point position) {
        if (texture == null) {
            return;
        }
        this.setTexture(texture);
        Point point = position.sub(new Point(texture.getBorder().l(), texture.getBorder().t()));
        Area textureArea = texture.getArea().outset(texture.getBorder());
        GuiUtils.drawTexturedModalRect((int)point.x(), (int)point.y(), (int)textureArea.pos().x(), (int)textureArea.pos().y(), (int)textureArea.size().x(), (int)textureArea.size().y(), (float)0.0f);
    }

    public void texture(Object window, Area area) {
        this.texture(this.getTexture(window), area);
    }

    public void texture(@Nullable Texture texture, Area area) {
        if (texture == null) {
            return;
        }
        this.setTexture(texture);
        Area textureArea = texture.getArea().outset(texture.getBorder());
        Area targetArea = area.outset(texture.getBorder());
        if (textureArea.width() == targetArea.width() && textureArea.height() == targetArea.height()) {
            Point position = targetArea.pos();
            GuiUtils.drawTexturedModalRect((int)position.x(), (int)position.y(), (int)textureArea.pos().x(), (int)textureArea.pos().y(), (int)textureArea.size().x(), (int)textureArea.size().y(), (float)0.0f);
        } else {
            TextureRenderer.renderTexturePadded(targetArea, textureArea, texture.getTotalPadding());
        }
    }

    public void limitArea(Area area, int guiWidth, int guiHeight) {
        float x = area.pos().x();
        float y = area.pos().y();
        float w = area.size().x();
        float h = area.size().y();
        y = (float)guiHeight - (y + h);
        Minecraft minecraft = Minecraft.func_71410_x();
        float scaleX = (float)guiWidth / (float)minecraft.field_71443_c;
        float scaleY = (float)guiHeight / (float)minecraft.field_71440_d;
        GL11.glScissor((int)((int)((x += 0.0f) / scaleX)), (int)((int)((y += 0.0f) / scaleY)), (int)((int)((w += 0.0f) / scaleX)), (int)((int)((h += 0.0f) / scaleY)));
    }

    public int textHeight(String text, int width) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        return fontRenderer.func_78271_c(text, width).size() * RenderUtil.getTextHeight();
    }

    public void texturePercentage(Texture texture, Area area, Position direction, float percentage) {
        int dist = direction == Position.Top || direction == Position.BOTTOM ? Math.round(percentage * (float)texture.height()) : Math.round(percentage * (float)texture.width());
        int dim = direction == Position.Top || direction == Position.BOTTOM ? texture.height() : texture.width();
        int x = area.pos().x();
        int y = area.pos().y();
        int w = area.size().x();
        int h = area.size().y();
        switch (direction) {
            case Top: {
                h = (int)((float)h * percentage);
                break;
            }
            case RIGHT: {
                x = (int)((float)x + (1.0f - percentage) * (float)w);
                w = (int)((float)w * percentage);
                break;
            }
            case LEFT: {
                w = (int)((float)w * percentage);
                break;
            }
            case BOTTOM: {
                y += h - (int)(percentage * (float)h);
                h = (int)((float)h * percentage);
            }
        }
        this.texture(texture.crop(direction, dim - dist), new Area(x, y, w, h));
    }

    public void test(IWidget widget) {
    }
}

