/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.Point;
import binnie.core.craftgui.minecraft.CustomSlot;
import binnie.core.craftgui.minecraft.GuiCraftGUI;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.WindowInventory;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlSlotArray;
import binnie.core.craftgui.minecraft.control.ControlSlotBase;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.craftgui.renderer.RenderUtil;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.SlotValidator;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlSlot
extends ControlSlotBase {
    public static final Map<EnumHighlighting, List<Integer>> highlighting = new EnumMap<EnumHighlighting, List<Integer>>(EnumHighlighting.class);
    public static boolean shiftClickActive = false;
    public final Slot slot;

    public ControlSlot(IWidget parent, int x, int y, Slot slot) {
        super(parent, x, y);
        this.slot = slot;
        this.addSelfEventHandler(new EventMouse.Down.Handler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onEvent(EventMouse.Down event) {
                Window superParent = (Window)ControlSlot.this.getTopParent();
                GuiCraftGUI superParentGui = superParent.getGui();
                Minecraft minecraft = superParentGui.getMinecraft();
                PlayerControllerMP playerController = minecraft.field_71442_b;
                int windowId = superParent.getContainer().field_75152_c;
                int slotNumber = ControlSlot.this.slot.field_75222_d;
                int button = event.getButton();
                ((Window)Window.get(ControlSlot.this.getWidget())).getGui();
                if (playerController != null) {
                    playerController.func_187098_a(windowId, slotNumber, button, GuiScreen.func_146272_n() ? ClickType.QUICK_MOVE : ClickType.PICKUP, (EntityPlayer)minecraft.field_71439_g);
                }
            }
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        TextureAtlasSprite icon;
        SlotValidator validator;
        CraftGUI.render.texture((Object)CraftGUITexture.Slot, Point.ZERO);
        InventorySlot islot = this.getInventorySlot();
        if (islot != null && (validator = islot.getValidator()) != null && (icon = validator.getIcon(!islot.getInputSides().isEmpty())) != null && icon != Minecraft.func_71410_x().func_147117_R().func_174944_f()) {
            GlStateManager.func_179147_l();
            RenderUtil.drawSprite(new Point(1, 1), icon);
            GlStateManager.func_179084_k();
        }
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.ShiftClick && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = -1442840576 + Math.min(highlight.getKey().getColour(), 0xFFFFFF);
            RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), c, c);
        }
        if (!highlighted && this.getTopParent().getMousedOverWidget() == this) {
            GuiCraftGUI gui = ((Window)Window.get(this)).getGui();
            if (!gui.getDraggedItem().func_190926_b() && !this.slot.func_75214_a(gui.getDraggedItem())) {
                RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), -1426089575, -1426089575);
            } else {
                RenderUtil.drawGradientRect(new Area(1, 1, 16, 16), -2130706433, -2130706433);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderOverlay() {
        boolean highlighted = false;
        for (Map.Entry<EnumHighlighting, List<Integer>> highlight : highlighting.entrySet()) {
            if (highlight.getKey() == EnumHighlighting.ShiftClick && !shiftClickActive || highlighted || !highlight.getValue().contains(this.slot.field_75222_d)) continue;
            highlighted = true;
            int c = highlight.getKey().getColour();
            Area area = this.getArea();
            if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
                area = this.getParent().getArea();
                area.setPosition(Point.ZERO.sub(this.getPosition()));
            }
            RenderUtil.setColour(c);
            CraftGUI.render.texture((Object)CraftGUITexture.Outline, area.outset(1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.isMouseOver() && GuiScreen.func_146272_n()) {
            ((Window)Window.get(this)).getContainer().setMouseOverSlot(this.slot);
            shiftClickActive = true;
        }
        if (((Window)Window.get(this)).getGui().isHelpMode() && this.isMouseOver()) {
            for (ControlSlot slot2 : this.getControlSlots()) {
                highlighting.get((Object)EnumHighlighting.Help).add(slot2.slot.field_75222_d);
            }
        }
    }

    private List<ControlSlot> getControlSlots() {
        ArrayList<ControlSlot> slots = new ArrayList<ControlSlot>();
        if (this.getParent() instanceof ControlSlotArray || this.getParent() instanceof ControlPlayerInventory) {
            for (IWidget child : this.getParent().getWidgets()) {
                slots.add((ControlSlot)child);
            }
        } else {
            slots.add(this);
        }
        return slots;
    }

    @Override
    public ItemStack getItemStack() {
        return this.slot.func_75211_c();
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        InventorySlot slot = this.getInventorySlot();
        if (slot != null) {
            tooltip.add(slot.getName());
            tooltip.add("Insert Side: " + MachineSide.asString(slot.getInputSides()));
            tooltip.add("Extract Side: " + MachineSide.asString(slot.getOutputSides()));
            if (slot.isReadOnly()) {
                tooltip.add("Pickup Only Slot");
            }
            tooltip.add("Accepts: " + (slot.getValidator() == null ? "Any Item" : slot.getValidator().getTooltip()));
        } else if (this.slot.field_75224_c instanceof WindowInventory) {
            SlotValidator s = ((WindowInventory)this.slot.field_75224_c).getValidator(this.slot.getSlotIndex());
            tooltip.add("Accepts: " + (s == null ? "Any Item" : s.getTooltip()));
        } else if (this.slot.field_75224_c instanceof InventoryPlayer) {
            tooltip.add("Player Inventory");
        }
    }

    @Nullable
    public InventorySlot getInventorySlot() {
        if (this.slot instanceof CustomSlot) {
            CustomSlot customSlot = (CustomSlot)this.slot;
            return customSlot.getInventorySlot();
        }
        return null;
    }

    static {
        for (EnumHighlighting h : EnumHighlighting.values()) {
            highlighting.put(h, new ArrayList());
        }
    }

    public static class Builder {
        private final IWidget parent;
        private final int x;
        private final int y;

        public Builder(IWidget parent, int x, int y) {
            this.parent = parent;
            this.x = x;
            this.y = y;
        }

        public ControlSlot assign(int index) {
            return this.assign(InventoryType.Machine, index);
        }

        public ControlSlot assign(InventoryType inventory, int index) {
            Slot slot = ((Window)this.parent.getTopParent()).getContainer().createClientSlot(inventory, index);
            return new ControlSlot(this.parent, this.x, this.y, slot);
        }
    }
}

